/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.set;

import com.netflix.hollow.core.memory.FixedLengthDataFactory;
import com.netflix.hollow.core.read.engine.HollowTypeDataElementsSplitter;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeDataElements;

public class HollowSetTypeDataElementsSplitter
extends HollowTypeDataElementsSplitter<HollowSetTypeDataElements> {
    public HollowSetTypeDataElementsSplitter(HollowSetTypeDataElements from, int numSplits) {
        super(from, numSplits);
    }

    @Override
    public void initToElements() {
        this.to = new HollowSetTypeDataElements[this.numSplits];
        for (int i = 0; i < ((HollowSetTypeDataElements[])this.to).length; ++i) {
            ((HollowSetTypeDataElements[])this.to)[i] = new HollowSetTypeDataElements(((HollowSetTypeDataElements)this.from).memoryMode, ((HollowSetTypeDataElements)this.from).memoryRecycler);
        }
    }

    @Override
    public void populateStats() {
        long[] shardTotalOfSetBuckets = new long[this.numSplits];
        long maxShardTotalOfSetBuckets = 0L;
        for (int ordinal = 0; ordinal <= ((HollowSetTypeDataElements)this.from).maxOrdinal; ++ordinal) {
            int toOrdinal;
            int toIndex = ordinal & this.toMask;
            ((HollowSetTypeDataElements[])this.to)[toIndex].maxOrdinal = toOrdinal = ordinal >> this.toOrdinalShift;
            long startBucket = ((HollowSetTypeDataElements)this.from).getStartBucket(ordinal);
            long endBucket = ((HollowSetTypeDataElements)this.from).getEndBucket(ordinal);
            long numBuckets = endBucket - startBucket;
            int n = toIndex;
            shardTotalOfSetBuckets[n] = shardTotalOfSetBuckets[n] + numBuckets;
            if (shardTotalOfSetBuckets[toIndex] <= maxShardTotalOfSetBuckets) continue;
            maxShardTotalOfSetBuckets = shardTotalOfSetBuckets[toIndex];
        }
        for (int toIndex = 0; toIndex < this.numSplits; ++toIndex) {
            HollowSetTypeDataElements target = ((HollowSetTypeDataElements[])this.to)[toIndex];
            target.bitsPerElement = ((HollowSetTypeDataElements)this.from).bitsPerElement;
            target.emptyBucketValue = ((HollowSetTypeDataElements)this.from).emptyBucketValue;
            target.bitsPerSetSizeValue = ((HollowSetTypeDataElements)this.from).bitsPerSetSizeValue;
            target.bitsPerSetPointer = 64 - Long.numberOfLeadingZeros(maxShardTotalOfSetBuckets);
            target.totalNumberOfBuckets = shardTotalOfSetBuckets[toIndex];
            target.bitsPerFixedLengthSetPortion = target.bitsPerSetPointer + target.bitsPerSetSizeValue;
        }
    }

    @Override
    public void copyRecords() {
        int numSplits = ((HollowSetTypeDataElements[])this.to).length;
        long[] bucketCounter = new long[numSplits];
        for (int toIndex = 0; toIndex < numSplits; ++toIndex) {
            HollowSetTypeDataElements target = ((HollowSetTypeDataElements[])this.to)[toIndex];
            target.setPointerAndSizeData = FixedLengthDataFactory.get(((long)target.maxOrdinal + 1L) * (long)target.bitsPerFixedLengthSetPortion, target.memoryMode, target.memoryRecycler);
            target.elementData = FixedLengthDataFactory.get(target.totalNumberOfBuckets * (long)target.bitsPerElement, target.memoryMode, target.memoryRecycler);
        }
        for (int ordinal = 0; ordinal <= ((HollowSetTypeDataElements)this.from).maxOrdinal; ++ordinal) {
            int toIndex = ordinal & this.toMask;
            int toOrdinal = ordinal >> this.toOrdinalShift;
            long startBucket = ((HollowSetTypeDataElements)this.from).getStartBucket(ordinal);
            long endBucket = ((HollowSetTypeDataElements)this.from).getEndBucket(ordinal);
            HollowSetTypeDataElements target = ((HollowSetTypeDataElements[])this.to)[toIndex];
            long numBuckets = endBucket - startBucket;
            target.copyBucketsFrom(bucketCounter[toIndex], (HollowSetTypeDataElements)this.from, startBucket, endBucket);
            int n = toIndex;
            bucketCounter[n] = bucketCounter[n] + numBuckets;
            target.setPointerAndSizeData.setElementValue((long)toOrdinal * (long)target.bitsPerFixedLengthSetPortion, target.bitsPerSetPointer, bucketCounter[toIndex]);
            long setSize = ((HollowSetTypeDataElements)this.from).setPointerAndSizeData.getElementValue((long)ordinal * (long)((HollowSetTypeDataElements)this.from).bitsPerFixedLengthSetPortion + (long)((HollowSetTypeDataElements)this.from).bitsPerSetPointer, ((HollowSetTypeDataElements)this.from).bitsPerSetSizeValue);
            target.setPointerAndSizeData.setElementValue((long)toOrdinal * (long)target.bitsPerFixedLengthSetPortion + (long)target.bitsPerSetPointer, target.bitsPerSetSizeValue, setSize);
        }
    }
}

