/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.set;

import com.netflix.hollow.core.memory.FixedLengthData;
import com.netflix.hollow.core.memory.FixedLengthDataFactory;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.engine.HollowTypeDataElements;
import com.netflix.hollow.core.read.engine.set.HollowSetDeltaApplicator;
import java.io.IOException;

public class HollowSetTypeDataElements
extends HollowTypeDataElements {
    public FixedLengthData setPointerAndSizeData;
    public FixedLengthData elementData;
    int bitsPerSetPointer;
    int bitsPerSetSizeValue;
    int bitsPerFixedLengthSetPortion;
    int bitsPerElement;
    int emptyBucketValue;
    long totalNumberOfBuckets;

    public HollowSetTypeDataElements(ArraySegmentRecycler memoryRecycler) {
        this(MemoryMode.ON_HEAP, memoryRecycler);
    }

    public HollowSetTypeDataElements(MemoryMode memoryMode, ArraySegmentRecycler memoryRecycler) {
        super(memoryMode, memoryRecycler);
    }

    void readSnapshot(HollowBlobInput in) throws IOException {
        this.readFromInput(in, false);
    }

    void readDelta(HollowBlobInput in) throws IOException {
        this.readFromInput(in, true);
    }

    private void readFromInput(HollowBlobInput in, boolean isDelta) throws IOException {
        this.maxOrdinal = VarInt.readVInt(in);
        if (isDelta) {
            this.encodedRemovals = GapEncodedVariableLengthIntegerReader.readEncodedDeltaOrdinals(in, this.memoryRecycler);
            this.encodedAdditions = GapEncodedVariableLengthIntegerReader.readEncodedDeltaOrdinals(in, this.memoryRecycler);
        }
        this.bitsPerSetPointer = VarInt.readVInt(in);
        this.bitsPerSetSizeValue = VarInt.readVInt(in);
        this.bitsPerElement = VarInt.readVInt(in);
        this.bitsPerFixedLengthSetPortion = this.bitsPerSetPointer + this.bitsPerSetSizeValue;
        this.emptyBucketValue = (1 << this.bitsPerElement) - 1;
        this.totalNumberOfBuckets = VarInt.readVLong(in);
        this.setPointerAndSizeData = FixedLengthDataFactory.get(in, this.memoryMode, this.memoryRecycler);
        this.elementData = FixedLengthDataFactory.get(in, this.memoryMode, this.memoryRecycler);
    }

    static void discardFromStream(HollowBlobInput in, int numShards, boolean isDelta) throws IOException {
        if (numShards > 1) {
            VarInt.readVInt(in);
        }
        for (int i = 0; i < numShards; ++i) {
            VarInt.readVInt(in);
            if (isDelta) {
                GapEncodedVariableLengthIntegerReader.discardEncodedDeltaOrdinals(in);
                GapEncodedVariableLengthIntegerReader.discardEncodedDeltaOrdinals(in);
            }
            VarInt.readVInt(in);
            VarInt.readVInt(in);
            VarInt.readVInt(in);
            VarInt.readVLong(in);
            FixedLengthData.discardFrom(in);
            FixedLengthData.discardFrom(in);
        }
    }

    public void applyDelta(HollowSetTypeDataElements fromData, HollowSetTypeDataElements deltaData) {
        new HollowSetDeltaApplicator(fromData, deltaData, this).applyDelta();
    }

    @Override
    public void destroy() {
        FixedLengthDataFactory.destroy(this.setPointerAndSizeData, this.memoryRecycler);
        FixedLengthDataFactory.destroy(this.elementData, this.memoryRecycler);
    }

    long getStartBucket(int ordinal) {
        return ordinal == 0 ? 0L : this.setPointerAndSizeData.getElementValue((long)(ordinal - 1) * (long)this.bitsPerFixedLengthSetPortion, this.bitsPerSetPointer);
    }

    long getEndBucket(int ordinal) {
        return this.setPointerAndSizeData.getElementValue((long)ordinal * (long)this.bitsPerFixedLengthSetPortion, this.bitsPerSetPointer);
    }

    int getBucketValue(long absoluteBucketIndex) {
        return (int)this.elementData.getElementValue(absoluteBucketIndex * (long)this.bitsPerElement, this.bitsPerElement);
    }

    void copyBucketsFrom(long startBucket, HollowSetTypeDataElements src, long srcStartBucket, long srcEndBucket) {
        if (this.bitsPerElement == src.bitsPerElement) {
            long numBuckets = srcEndBucket - srcStartBucket;
            this.elementData.copyBits(src.elementData, srcStartBucket * (long)this.bitsPerElement, startBucket * (long)this.bitsPerElement, numBuckets * (long)this.bitsPerElement);
        } else {
            for (long bucket = srcStartBucket; bucket < srcEndBucket; ++bucket) {
                long bucketVal = src.elementData.getElementValue(bucket * (long)src.bitsPerElement, src.bitsPerElement);
                if (bucketVal == (long)src.emptyBucketValue) {
                    bucketVal = this.emptyBucketValue;
                }
                this.elementData.setElementValue(startBucket * (long)this.bitsPerElement, this.bitsPerElement, bucketVal);
                ++startBucket;
            }
        }
    }
}

