/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.object;

import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeDataElements;
import com.netflix.hollow.core.schema.HollowObjectSchema;

class HollowObjectDeltaApplicator {
    private final HollowObjectTypeDataElements from;
    private final HollowObjectTypeDataElements delta;
    private final HollowObjectTypeDataElements target;
    long currentDeltaStateReadFixedLengthStartBit = 0L;
    long currentFromStateReadFixedLengthStartBit = 0L;
    long currentWriteFixedLengthStartBit = 0L;
    long[] currentDeltaReadVarLengthDataPointers;
    long[] currentFromStateReadVarLengthDataPointers;
    long[] currentWriteVarLengthDataPointers;
    int[] deltaFieldIndexMapping;
    GapEncodedVariableLengthIntegerReader removalsReader;
    GapEncodedVariableLengthIntegerReader additionsReader;
    int numMergeFields = 0;

    public HollowObjectDeltaApplicator(HollowObjectTypeDataElements from, HollowObjectTypeDataElements delta, HollowObjectTypeDataElements target) {
        this.from = from;
        this.delta = delta;
        this.target = target;
    }

    void applyDelta() {
        int i;
        this.removalsReader = this.from.encodedRemovals == null ? GapEncodedVariableLengthIntegerReader.EMPTY_READER : this.from.encodedRemovals;
        this.additionsReader = this.delta.encodedAdditions;
        this.removalsReader.reset();
        this.additionsReader.reset();
        this.target.encodedRemovals = this.delta.encodedRemovals;
        this.target.maxOrdinal = this.delta.maxOrdinal;
        this.deltaFieldIndexMapping = new int[this.target.bitsPerField.length];
        for (i = 0; i < this.target.bitsPerField.length; ++i) {
            this.deltaFieldIndexMapping[i] = this.delta.schema.getPosition(this.target.schema.getFieldName(i));
        }
        for (i = 0; i < this.target.bitsPerField.length; ++i) {
            this.target.bitsPerField[i] = this.deltaFieldIndexMapping[i] == -1 ? this.from.bitsPerField[i] : this.delta.bitsPerField[this.deltaFieldIndexMapping[i]];
            this.target.nullValueForField[i] = this.target.bitsPerField[i] == 64 ? -1L : (1L << this.target.bitsPerField[i]) - 1L;
            this.target.bitOffsetPerField[i] = this.target.bitsPerRecord;
            this.target.bitsPerRecord += this.target.bitsPerField[i];
            if (this.target.bitsPerField[i] == 0) continue;
            this.numMergeFields = i + 1;
        }
        this.target.fixedLengthData = new FixedLengthElementArray(this.target.memoryRecycler, (long)this.target.bitsPerRecord * (long)(this.target.maxOrdinal + 1));
        for (i = 0; i < this.target.schema.numFields(); ++i) {
            if (this.target.schema.getFieldType(i) != HollowObjectSchema.FieldType.STRING && this.target.schema.getFieldType(i) != HollowObjectSchema.FieldType.BYTES) continue;
            this.target.varLengthData[i] = new SegmentedByteArray(this.target.memoryRecycler);
        }
        this.currentDeltaReadVarLengthDataPointers = new long[this.target.varLengthData.length];
        this.currentFromStateReadVarLengthDataPointers = new long[this.target.varLengthData.length];
        this.currentWriteVarLengthDataPointers = new long[this.target.varLengthData.length];
        if (this.canDoFastDelta()) {
            this.fastDelta();
        } else {
            this.slowDelta();
        }
        this.from.encodedRemovals = null;
        this.removalsReader.destroy();
    }

    private boolean canDoFastDelta() {
        for (int i = 0; i < this.target.bitsPerField.length; ++i) {
            if (this.target.bitsPerField[i] == this.from.bitsPerField[i]) continue;
            return false;
        }
        return true;
    }

    private void fastDelta() {
        int i = 0;
        int bulkCopyEndOrdinal = Math.min(this.from.maxOrdinal, this.target.maxOrdinal);
        while (i <= this.target.maxOrdinal) {
            int nextElementDiff = Math.min(this.additionsReader.nextElement(), this.removalsReader.nextElement());
            if (nextElementDiff == i || i > bulkCopyEndOrdinal) {
                this.mergeOrdinal(i++);
                continue;
            }
            int recordsToCopy = nextElementDiff - i;
            if (nextElementDiff > bulkCopyEndOrdinal) {
                recordsToCopy = bulkCopyEndOrdinal - i + 1;
            }
            this.fastCopyRecords(recordsToCopy);
            i += recordsToCopy;
        }
    }

    private void fastCopyRecords(int recordsToCopy) {
        long fixedLengthBitsToCopy = (long)this.from.bitsPerRecord * (long)recordsToCopy;
        this.target.fixedLengthData.copyBits(this.from.fixedLengthData, this.currentFromStateReadFixedLengthStartBit, this.currentWriteFixedLengthStartBit, fixedLengthBitsToCopy);
        this.currentFromStateReadFixedLengthStartBit += fixedLengthBitsToCopy;
        for (int i = 0; i < this.from.schema.numFields(); ++i) {
            if (this.target.varLengthData[i] == null) continue;
            long fromEndByte = this.from.fixedLengthData.getElementValue(this.currentFromStateReadFixedLengthStartBit - (long)this.from.bitsPerRecord + (long)this.from.bitOffsetPerField[i], this.from.bitsPerField[i]);
            long varLengthToCopy = (fromEndByte &= this.from.nullValueForField[i] >>> 1) - this.currentFromStateReadVarLengthDataPointers[i];
            long varLengthDiff = this.currentWriteVarLengthDataPointers[i] - this.currentFromStateReadVarLengthDataPointers[i];
            this.target.varLengthData[i].orderedCopy(this.from.varLengthData[i], this.currentFromStateReadVarLengthDataPointers[i], this.currentWriteVarLengthDataPointers[i], varLengthToCopy);
            this.target.fixedLengthData.incrementMany(this.currentWriteFixedLengthStartBit + (long)this.from.bitOffsetPerField[i], varLengthDiff, this.from.bitsPerRecord, recordsToCopy);
            int n = i;
            this.currentFromStateReadVarLengthDataPointers[n] = this.currentFromStateReadVarLengthDataPointers[n] + varLengthToCopy;
            int n2 = i;
            this.currentWriteVarLengthDataPointers[n2] = this.currentWriteVarLengthDataPointers[n2] + varLengthToCopy;
        }
        this.currentWriteFixedLengthStartBit += fixedLengthBitsToCopy;
    }

    private void slowDelta() {
        for (int i = 0; i <= this.target.maxOrdinal; ++i) {
            this.mergeOrdinal(i);
        }
    }

    private void mergeOrdinal(int i) {
        boolean addFromDelta = this.additionsReader.nextElement() == i;
        boolean removeData = this.removalsReader.nextElement() == i;
        for (int fieldIndex = 0; fieldIndex < this.numMergeFields; ++fieldIndex) {
            int deltaFieldIndex = this.deltaFieldIndexMapping[fieldIndex];
            if (addFromDelta) {
                this.addFromDelta(removeData, fieldIndex, deltaFieldIndex);
            } else if (i <= this.from.maxOrdinal) {
                long readStartBit = this.currentFromStateReadFixedLengthStartBit + (long)this.from.bitOffsetPerField[fieldIndex];
                this.copyRecordField(fieldIndex, fieldIndex, this.from, readStartBit, this.currentWriteFixedLengthStartBit, this.currentFromStateReadVarLengthDataPointers, this.currentWriteVarLengthDataPointers, removeData);
            } else if (this.target.varLengthData[fieldIndex] != null) {
                HollowObjectTypeDataElements.writeNullVarLengthField(this.target, fieldIndex, this.currentWriteFixedLengthStartBit, this.currentWriteVarLengthDataPointers);
            }
            this.currentWriteFixedLengthStartBit += (long)this.target.bitsPerField[fieldIndex];
        }
        if (addFromDelta) {
            this.currentDeltaStateReadFixedLengthStartBit += (long)this.delta.bitsPerRecord;
            this.additionsReader.advance();
        }
        this.currentFromStateReadFixedLengthStartBit += (long)this.from.bitsPerRecord;
        if (removeData) {
            this.removalsReader.advance();
        }
    }

    private void addFromDelta(boolean removeData, int fieldIndex, int deltaFieldIndex) {
        long readValue;
        if (deltaFieldIndex == -1) {
            HollowObjectTypeDataElements.writeNullField(this.target, fieldIndex, this.currentWriteFixedLengthStartBit, this.currentWriteVarLengthDataPointers);
        } else {
            long readStartBit = this.currentDeltaStateReadFixedLengthStartBit + (long)this.delta.bitOffsetPerField[deltaFieldIndex];
            this.copyRecordField(fieldIndex, deltaFieldIndex, this.delta, readStartBit, this.currentWriteFixedLengthStartBit, this.currentDeltaReadVarLengthDataPointers, this.currentWriteVarLengthDataPointers, false);
        }
        if (removeData && this.target.varLengthData[fieldIndex] != null && ((readValue = this.from.fixedLengthData.getElementValue(this.currentFromStateReadFixedLengthStartBit + (long)this.from.bitOffsetPerField[fieldIndex], this.from.bitsPerField[fieldIndex])) & 1L << this.from.bitsPerField[fieldIndex] - 1) == 0L) {
            this.currentFromStateReadVarLengthDataPointers[fieldIndex] = readValue;
        }
    }

    private void copyRecordField(int fieldIndex, int fromFieldIndex, HollowObjectTypeDataElements copyFromData, long currentReadFixedLengthStartBit, long currentWriteFixedLengthStartBit, long[] currentReadVarLengthDataPointers, long[] currentWriteVarLengthDataPointers, boolean removeData) {
        long readValue;
        long l = readValue = copyFromData.bitsPerField[fromFieldIndex] > 56 ? copyFromData.fixedLengthData.getLargeElementValue(currentReadFixedLengthStartBit, copyFromData.bitsPerField[fromFieldIndex]) : copyFromData.fixedLengthData.getElementValue(currentReadFixedLengthStartBit, copyFromData.bitsPerField[fromFieldIndex]);
        if (this.target.varLengthData[fieldIndex] != null) {
            if ((readValue & 1L << copyFromData.bitsPerField[fromFieldIndex] - 1) != 0L) {
                HollowObjectTypeDataElements.writeNullVarLengthField(this.target, fieldIndex, currentWriteFixedLengthStartBit, currentWriteVarLengthDataPointers);
            } else {
                long readStart = currentReadVarLengthDataPointers[fieldIndex];
                long length = readValue - readStart;
                if (!removeData) {
                    long writeStart = currentWriteVarLengthDataPointers[fieldIndex];
                    this.target.varLengthData[fieldIndex].orderedCopy(copyFromData.varLengthData[fromFieldIndex], readStart, writeStart, length);
                    int n = fieldIndex;
                    currentWriteVarLengthDataPointers[n] = currentWriteVarLengthDataPointers[n] + length;
                }
                this.target.fixedLengthData.setElementValue(currentWriteFixedLengthStartBit, this.target.bitsPerField[fieldIndex], currentWriteVarLengthDataPointers[fieldIndex]);
                currentReadVarLengthDataPointers[fieldIndex] = readValue;
            }
        } else if (!removeData) {
            if (readValue == copyFromData.nullValueForField[fromFieldIndex]) {
                HollowObjectTypeDataElements.writeNullFixedLengthField(this.target, fieldIndex, currentWriteFixedLengthStartBit);
            } else {
                this.target.fixedLengthData.setElementValue(currentWriteFixedLengthStartBit, this.target.bitsPerField[fieldIndex], readValue);
            }
        }
    }
}

