/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.map;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;

public class PotentialMatchHollowMapEntryOrdinalIteratorImpl
implements HollowMapEntryOrdinalIterator {
    private final int mapOrdinal;
    private final HollowMapTypeDataAccess dataAccess;
    private final int numBuckets;
    private int currentBucket;
    private int key;
    private int value;

    public PotentialMatchHollowMapEntryOrdinalIteratorImpl(int mapOrdinal, HollowMapTypeDataAccess dataAccess, int hashCode) {
        this.mapOrdinal = mapOrdinal;
        this.dataAccess = dataAccess;
        this.numBuckets = HashCodes.hashTableSize(dataAccess.size(mapOrdinal));
        this.currentBucket = HashCodes.hashInt(hashCode) & this.numBuckets - 1;
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public boolean next() {
        long currentBucketValue = this.dataAccess.relativeBucket(this.mapOrdinal, this.currentBucket);
        int currentBucketKey = (int)(currentBucketValue >>> 32);
        if (currentBucketKey == -1) {
            return false;
        }
        this.key = currentBucketKey;
        this.value = (int)currentBucketValue;
        ++this.currentBucket;
        this.currentBucket &= this.numBuckets - 1;
        return true;
    }
}

