/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.list;

import com.netflix.hollow.core.read.engine.HollowTypeReadStateShard;
import com.netflix.hollow.core.read.engine.list.HollowListTypeDataElements;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.util.BitSet;

class HollowListTypeReadStateShard
implements HollowTypeReadStateShard {
    final HollowListTypeDataElements dataElements;
    final int shardOrdinalShift;

    @Override
    public HollowListTypeDataElements getDataElements() {
        return this.dataElements;
    }

    @Override
    public int getShardOrdinalShift() {
        return this.shardOrdinalShift;
    }

    public HollowListTypeReadStateShard(HollowListTypeDataElements dataElements, int shardOrdinalShift) {
        this.shardOrdinalShift = shardOrdinalShift;
        this.dataElements = dataElements;
    }

    public int size(int ordinal) {
        long startElement = this.dataElements.getStartElement(ordinal);
        long endElement = this.dataElements.getEndElement(ordinal);
        int size = (int)(endElement - startElement);
        return size;
    }

    protected void applyShardToChecksum(HollowChecksum checksum, BitSet populatedOrdinals, int shardNumber, int numShards) {
        int ordinal = populatedOrdinals.nextSetBit(shardNumber);
        while (ordinal != -1) {
            if ((ordinal & numShards - 1) == shardNumber) {
                int shardOrdinal = ordinal / numShards;
                int size = this.size(shardOrdinal);
                checksum.applyInt(ordinal);
                long startElement = this.dataElements.getStartElement(shardOrdinal);
                long endElement = this.dataElements.getEndElement(shardOrdinal);
                for (int i = 0; i < size; ++i) {
                    checksum.applyInt(this.getElementOrdinal(startElement, endElement, i));
                }
                ordinal += numShards;
            } else {
                int r = (ordinal & -numShards) + shardNumber;
                ordinal = r <= ordinal ? r + numShards : r;
            }
            ordinal = populatedOrdinals.nextSetBit(ordinal);
        }
    }

    int getElementOrdinal(long startElement, long endElement, int listIndex) {
        long elementIndex = startElement + (long)listIndex;
        if (elementIndex >= endElement) {
            throw new ArrayIndexOutOfBoundsException("Array index out of bounds: " + listIndex + ", list size: " + (endElement - startElement));
        }
        int elementOrdinal = (int)this.dataElements.elementData.getElementValue(elementIndex * (long)this.dataElements.bitsPerElement, this.dataElements.bitsPerElement);
        return elementOrdinal;
    }

    public long getApproximateHeapFootprintInBytes() {
        long requiredListPointerBits = ((long)this.dataElements.maxOrdinal + 1L) * (long)this.dataElements.bitsPerListPointer;
        long requiredElementBits = this.dataElements.totalNumberOfElements * (long)this.dataElements.bitsPerElement;
        long requiredBits = requiredListPointerBits + requiredElementBits;
        return requiredBits / 8L;
    }

    public long getApproximateHoleCostInBytes(BitSet populatedOrdinals, int shardNumber, int numShards) {
        long holeBits = 0L;
        int holeOrdinal = populatedOrdinals.nextClearBit(0);
        while (holeOrdinal <= this.dataElements.maxOrdinal) {
            if ((holeOrdinal & numShards - 1) == shardNumber) {
                holeBits += (long)this.dataElements.bitsPerListPointer;
            }
            holeOrdinal = populatedOrdinals.nextClearBit(holeOrdinal + 1);
        }
        return holeBits / 8L;
    }
}

