/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.list;

import com.netflix.hollow.core.memory.FixedLengthDataFactory;
import com.netflix.hollow.core.read.engine.HollowTypeDataElements;
import com.netflix.hollow.core.read.engine.HollowTypeDataElementsJoiner;
import com.netflix.hollow.core.read.engine.list.HollowListTypeDataElements;

class HollowListTypeDataElementsJoiner
extends HollowTypeDataElementsJoiner<HollowListTypeDataElements> {
    public HollowListTypeDataElementsJoiner(HollowListTypeDataElements[] from) {
        super((HollowTypeDataElements[])from);
    }

    @Override
    public void initToElements() {
        this.to = new HollowListTypeDataElements(((HollowListTypeDataElements[])this.from)[0].memoryMode, ((HollowListTypeDataElements[])this.from)[0].memoryRecycler);
    }

    @Override
    public void populateStats() {
        for (int fromIndex = 0; fromIndex < ((HollowListTypeDataElements[])this.from).length; ++fromIndex) {
            int mappedMaxOrdinal = ((HollowListTypeDataElements[])this.from)[fromIndex].maxOrdinal == -1 ? -1 : ((HollowListTypeDataElements[])this.from)[fromIndex].maxOrdinal * ((HollowListTypeDataElements[])this.from).length + fromIndex;
            ((HollowListTypeDataElements)this.to).maxOrdinal = Math.max(((HollowListTypeDataElements)this.to).maxOrdinal, mappedMaxOrdinal);
            if (((HollowListTypeDataElements[])this.from)[fromIndex].bitsPerElement <= ((HollowListTypeDataElements)this.to).bitsPerElement) continue;
            ((HollowListTypeDataElements)this.to).bitsPerElement = ((HollowListTypeDataElements[])this.from)[fromIndex].bitsPerElement;
        }
        long totalOfListSizes = 0L;
        for (int ordinal = 0; ordinal <= ((HollowListTypeDataElements)this.to).maxOrdinal; ++ordinal) {
            int fromIndex = ordinal & this.fromMask;
            int fromOrdinal = ordinal >> this.fromOrdinalShift;
            if (fromOrdinal > ((HollowListTypeDataElements[])this.from)[fromIndex].maxOrdinal) continue;
            long startElement = ((HollowListTypeDataElements[])this.from)[fromIndex].getStartElement(fromOrdinal);
            long endElement = ((HollowListTypeDataElements[])this.from)[fromIndex].getEndElement(fromOrdinal);
            long numElements = endElement - startElement;
            totalOfListSizes += numElements;
        }
        ((HollowListTypeDataElements)this.to).bitsPerListPointer = totalOfListSizes == 0L ? 1 : 64 - Long.numberOfLeadingZeros(totalOfListSizes);
        ((HollowListTypeDataElements)this.to).totalNumberOfElements = totalOfListSizes;
    }

    @Override
    public void copyRecords() {
        long elementCounter = 0L;
        ((HollowListTypeDataElements)this.to).listPointerData = FixedLengthDataFactory.get((long)((HollowListTypeDataElements)this.to).bitsPerListPointer * (long)(((HollowListTypeDataElements)this.to).maxOrdinal + 1), ((HollowListTypeDataElements)this.to).memoryMode, ((HollowListTypeDataElements)this.to).memoryRecycler);
        ((HollowListTypeDataElements)this.to).elementData = FixedLengthDataFactory.get((long)((HollowListTypeDataElements)this.to).bitsPerElement * ((HollowListTypeDataElements)this.to).totalNumberOfElements, ((HollowListTypeDataElements)this.to).memoryMode, ((HollowListTypeDataElements)this.to).memoryRecycler);
        for (int ordinal = 0; ordinal <= ((HollowListTypeDataElements)this.to).maxOrdinal; ++ordinal) {
            int fromIndex = ordinal & this.fromMask;
            int fromOrdinal = ordinal >> this.fromOrdinalShift;
            if (fromOrdinal <= ((HollowListTypeDataElements[])this.from)[fromIndex].maxOrdinal) {
                HollowListTypeDataElements source = ((HollowListTypeDataElements[])this.from)[fromIndex];
                long startElement = source.getStartElement(fromOrdinal);
                long endElement = source.getEndElement(fromOrdinal);
                long numElements = endElement - startElement;
                ((HollowListTypeDataElements)this.to).copyElementsFrom(elementCounter, source, startElement, endElement);
                elementCounter += numElements;
            }
            ((HollowListTypeDataElements)this.to).listPointerData.setElementValue((long)((HollowListTypeDataElements)this.to).bitsPerListPointer * (long)ordinal, ((HollowListTypeDataElements)this.to).bitsPerListPointer, elementCounter);
        }
    }
}

