/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine;

import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.engine.HollowTypeStateListener;
import java.io.IOException;

public class SnapshotPopulatedOrdinalsReader {
    public static void readOrdinals(HollowBlobInput in, HollowTypeStateListener[] listeners) throws IOException {
        int numLongs = in.readInt();
        int currentOrdinal = 0;
        for (int i = 0; i < numLongs; ++i) {
            long l = in.readLong();
            SnapshotPopulatedOrdinalsReader.notifyPopulatedOrdinals(l, currentOrdinal, listeners);
            currentOrdinal += 64;
        }
    }

    private static void notifyPopulatedOrdinals(long l, int ordinal, HollowTypeStateListener[] listeners) {
        if (l == 0L) {
            return;
        }
        int stopOrdinal = ordinal + 64;
        while (ordinal < stopOrdinal) {
            long mask = 1L << ordinal;
            if ((l & mask) != 0L) {
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].addedOrdinal(ordinal);
                }
            }
            ++ordinal;
        }
    }

    public static void discardOrdinals(HollowBlobInput in) throws IOException {
        long numLongs = in.readInt();
        for (long bytesToSkip = numLongs * 8L; bytesToSkip > 0L; bytesToSkip -= in.skipBytes(bytesToSkip)) {
        }
    }
}

