/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine;

import com.netflix.hollow.core.read.engine.HollowTypeStateListener;
import java.util.BitSet;

public class PopulatedOrdinalListener
implements HollowTypeStateListener {
    private final BitSet previousOrdinals;
    private final BitSet populatedOrdinals = new BitSet();

    public PopulatedOrdinalListener() {
        this.previousOrdinals = new BitSet();
    }

    @Override
    public void beginUpdate() {
        this.previousOrdinals.clear();
        this.previousOrdinals.or(this.populatedOrdinals);
    }

    @Override
    public void addedOrdinal(int ordinal) {
        this.populatedOrdinals.set(ordinal);
    }

    @Override
    public void removedOrdinal(int ordinal) {
        this.populatedOrdinals.clear(ordinal);
    }

    @Override
    public void endUpdate() {
    }

    public boolean updatedLastCycle() {
        return !this.populatedOrdinals.equals(this.previousOrdinals);
    }

    public BitSet getPopulatedOrdinals() {
        return this.populatedOrdinals;
    }

    public BitSet getPreviousOrdinals() {
        return this.previousOrdinals;
    }
}

