/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine;

import com.netflix.hollow.core.HollowBlobHeader;
import com.netflix.hollow.core.HollowBlobOptionalPartHeader;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.OptionalBlobPartInput;
import com.netflix.hollow.core.read.engine.HollowBlobHeaderReader;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.HollowTypeReshardingStrategy;
import com.netflix.hollow.core.read.engine.HollowTypeStateListener;
import com.netflix.hollow.core.read.engine.list.HollowListTypeReadState;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeReadState;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.filter.TypeFilter;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;

public class HollowBlobReader {
    private final Logger log = Logger.getLogger(HollowBlobReader.class.getName());
    private final HollowReadStateEngine stateEngine;
    private final MemoryMode memoryMode;
    private final HollowBlobHeaderReader headerReader;

    public HollowBlobReader(HollowReadStateEngine stateEngine) {
        this(stateEngine, new HollowBlobHeaderReader());
    }

    public HollowBlobReader(HollowReadStateEngine stateEngine, HollowBlobHeaderReader headerReader) {
        this(stateEngine, headerReader, MemoryMode.ON_HEAP);
    }

    public HollowBlobReader(HollowReadStateEngine stateEngine, MemoryMode memoryMode) {
        this(stateEngine, new HollowBlobHeaderReader(), memoryMode);
    }

    public HollowBlobReader(HollowReadStateEngine stateEngine, HollowBlobHeaderReader headerReader, MemoryMode memoryMode) {
        this.stateEngine = stateEngine;
        this.headerReader = headerReader;
        this.memoryMode = memoryMode;
    }

    public void readSnapshot(InputStream is) throws IOException {
        HollowBlobInput hbi = HollowBlobInput.serial(is);
        this.readSnapshot(hbi);
    }

    public void readSnapshot(HollowBlobInput in) throws IOException {
        this.readSnapshot(in, (TypeFilter)new HollowFilterConfig(true));
    }

    @Deprecated
    public void readSnapshot(InputStream is, HollowFilterConfig filter) throws IOException {
        HollowBlobInput hbi = HollowBlobInput.serial(is);
        this.readSnapshot(hbi, (TypeFilter)filter);
    }

    public void readSnapshot(InputStream is, TypeFilter filter) throws IOException {
        HollowBlobInput hbi = HollowBlobInput.serial(is);
        this.readSnapshot(hbi, filter);
    }

    public void readSnapshot(HollowBlobInput in, TypeFilter filter) throws IOException {
        this.readSnapshot(in, null, filter);
    }

    public void readSnapshot(HollowBlobInput in, OptionalBlobPartInput optionalParts) throws IOException {
        this.readSnapshot(in, optionalParts, new HollowFilterConfig(true));
    }

    public void readSnapshot(HollowBlobInput in, OptionalBlobPartInput optionalParts, TypeFilter filter) throws IOException {
        this.validateMemoryMode(in.getMemoryMode());
        Map<String, HollowBlobInput> optionalPartInputs = null;
        if (optionalParts != null) {
            optionalPartInputs = optionalParts.getInputsByPartName(in.getMemoryMode());
        }
        HollowBlobHeader header = this.readHeader(in, false);
        List<HollowBlobOptionalPartHeader> partHeaders = this.readPartHeaders(header, optionalPartInputs, in.getMemoryMode());
        List<HollowSchema> allSchemas = this.combineSchemas(header, partHeaders);
        filter = filter.resolve(allSchemas);
        this.notifyBeginUpdate();
        long startTime = System.currentTimeMillis();
        int numStates = VarInt.readVInt(in);
        TreeSet<String> typeNames = new TreeSet<String>();
        for (int i = 0; i < numStates; ++i) {
            String typeName = this.readTypeStateSnapshot(in, filter);
            typeNames.add(typeName);
        }
        if (optionalPartInputs != null) {
            for (Map.Entry<String, HollowBlobInput> optionalPartEntry : optionalPartInputs.entrySet()) {
                numStates = VarInt.readVInt(optionalPartEntry.getValue());
                for (int i = 0; i < numStates; ++i) {
                    String typeName = this.readTypeStateSnapshot(optionalPartEntry.getValue(), filter);
                    typeNames.add(typeName);
                }
            }
        }
        this.stateEngine.wireTypeStatesToSchemas();
        long endTime = System.currentTimeMillis();
        this.log.info("SNAPSHOT COMPLETED IN " + (endTime - startTime) + "ms");
        this.log.info("TYPES: " + typeNames);
        this.notifyEndUpdate();
        this.stateEngine.afterInitialization();
    }

    public void applyDelta(InputStream in) throws IOException {
        HollowBlobInput hbi = HollowBlobInput.serial(in);
        this.applyDelta(hbi);
    }

    public void applyDelta(HollowBlobInput in) throws IOException {
        this.applyDelta(in, null);
    }

    public void applyDelta(HollowBlobInput in, OptionalBlobPartInput optionalParts) throws IOException {
        this.validateMemoryMode(in.getMemoryMode());
        Map<String, HollowBlobInput> optionalPartInputs = null;
        if (optionalParts != null) {
            optionalPartInputs = optionalParts.getInputsByPartName(in.getMemoryMode());
        }
        HollowBlobHeader header = this.readHeader(in, true);
        List<HollowBlobOptionalPartHeader> partHeaders = this.readPartHeaders(header, optionalPartInputs, in.getMemoryMode());
        this.notifyBeginUpdate();
        long startTime = System.currentTimeMillis();
        int numStates = VarInt.readVInt(in);
        TreeSet<String> typeNames = new TreeSet<String>();
        for (int i = 0; i < numStates; ++i) {
            String typeName = this.readTypeStateDelta(in);
            typeNames.add(typeName);
            this.stateEngine.getMemoryRecycler().swap();
        }
        if (optionalPartInputs != null) {
            for (Map.Entry<String, HollowBlobInput> optionalPartEntry : optionalPartInputs.entrySet()) {
                numStates = VarInt.readVInt(optionalPartEntry.getValue());
                for (int i = 0; i < numStates; ++i) {
                    String typeName = this.readTypeStateDelta(optionalPartEntry.getValue());
                    typeNames.add(typeName);
                    this.stateEngine.getMemoryRecycler().swap();
                }
            }
        }
        long endTime = System.currentTimeMillis();
        this.log.info("DELTA COMPLETED IN " + (endTime - startTime) + "ms");
        this.log.info("TYPES: " + typeNames);
        this.notifyEndUpdate();
    }

    private HollowBlobHeader readHeader(HollowBlobInput in, boolean isDelta) throws IOException {
        HollowBlobHeader header = this.headerReader.readHeader(in);
        if (isDelta && header.getOriginRandomizedTag() != this.stateEngine.getCurrentRandomizedTag()) {
            throw new IOException("Attempting to apply a delta to a state from which it was not originated!");
        }
        this.stateEngine.setCurrentRandomizedTag(header.getDestinationRandomizedTag());
        this.stateEngine.setOriginRandomizedTag(header.getOriginRandomizedTag());
        this.stateEngine.setHeaderTags(header.getHeaderTags());
        return header;
    }

    private List<HollowBlobOptionalPartHeader> readPartHeaders(HollowBlobHeader header, Map<String, HollowBlobInput> inputsByPartName, MemoryMode mode) throws IOException {
        if (inputsByPartName == null) {
            return Collections.emptyList();
        }
        ArrayList<HollowBlobOptionalPartHeader> list = new ArrayList<HollowBlobOptionalPartHeader>(inputsByPartName.size());
        for (Map.Entry<String, HollowBlobInput> entry : inputsByPartName.entrySet()) {
            HollowBlobOptionalPartHeader partHeader = this.headerReader.readPartHeader(entry.getValue());
            if (!partHeader.getPartName().equals(entry.getKey())) {
                throw new IllegalArgumentException("Optional blob part expected name " + entry.getKey() + " but was " + partHeader.getPartName());
            }
            if (partHeader.getOriginRandomizedTag() != header.getOriginRandomizedTag() || partHeader.getDestinationRandomizedTag() != header.getDestinationRandomizedTag()) {
                throw new IllegalArgumentException("Optional blob part " + entry.getKey() + " does not appear to be matched with the main input");
            }
            list.add(partHeader);
        }
        return list;
    }

    private List<HollowSchema> combineSchemas(HollowBlobHeader header, List<HollowBlobOptionalPartHeader> partHeaders) throws IOException {
        if (partHeaders.isEmpty()) {
            return header.getSchemas();
        }
        ArrayList<HollowSchema> schemas = new ArrayList<HollowSchema>(header.getSchemas());
        for (HollowBlobOptionalPartHeader partHeader : partHeaders) {
            schemas.addAll(partHeader.getSchemas());
        }
        return schemas;
    }

    private void notifyBeginUpdate() {
        for (HollowTypeReadState typeFile : this.stateEngine.getTypeStates()) {
            for (HollowTypeStateListener listener : typeFile.getListeners()) {
                listener.beginUpdate();
            }
        }
    }

    private void notifyEndUpdate() {
        for (HollowTypeReadState typeFile : this.stateEngine.getTypeStates()) {
            for (HollowTypeStateListener listener : typeFile.getListeners()) {
                listener.endUpdate();
            }
        }
    }

    private String readTypeStateSnapshot(HollowBlobInput in, TypeFilter filter) throws IOException {
        HollowSchema schema = HollowSchema.readFrom(in);
        int numShards = this.readNumShards(in);
        String typeName = schema.getName();
        if (schema instanceof HollowObjectSchema) {
            if (!filter.includes(typeName)) {
                HollowObjectTypeReadState.discardSnapshot(in, (HollowObjectSchema)schema, numShards);
            } else {
                HollowObjectSchema unfilteredSchema = (HollowObjectSchema)schema;
                HollowObjectSchema filteredSchema = unfilteredSchema.filterSchema(filter);
                this.populateTypeStateSnapshotWithNumShards(in, new HollowObjectTypeReadState(this.stateEngine, this.memoryMode, filteredSchema, unfilteredSchema), numShards);
            }
        } else if (schema instanceof HollowListSchema) {
            if (!filter.includes(typeName)) {
                HollowListTypeReadState.discardSnapshot(in, numShards);
            } else {
                this.populateTypeStateSnapshotWithNumShards(in, new HollowListTypeReadState(this.stateEngine, this.memoryMode, (HollowListSchema)schema), numShards);
            }
        } else if (schema instanceof HollowSetSchema) {
            if (!filter.includes(typeName)) {
                HollowSetTypeReadState.discardSnapshot(in, numShards);
            } else {
                this.populateTypeStateSnapshotWithNumShards(in, new HollowSetTypeReadState(this.stateEngine, this.memoryMode, (HollowSetSchema)schema), numShards);
            }
        } else if (schema instanceof HollowMapSchema) {
            if (!filter.includes(typeName)) {
                HollowMapTypeReadState.discardSnapshot(in, numShards);
            } else {
                this.populateTypeStateSnapshotWithNumShards(in, new HollowMapTypeReadState(this.stateEngine, this.memoryMode, (HollowMapSchema)schema), numShards);
            }
        }
        return typeName;
    }

    private void populateTypeStateSnapshotWithNumShards(HollowBlobInput in, HollowTypeReadState typeState, int numShards) throws IOException {
        if (numShards <= 0 || (numShards & numShards - 1) != 0) {
            throw new IllegalArgumentException("Number of shards must be a power of 2!");
        }
        this.stateEngine.addTypeState(typeState);
        typeState.readSnapshot(in, this.stateEngine.getMemoryRecycler(), numShards);
    }

    private String readTypeStateDelta(HollowBlobInput in) throws IOException {
        HollowSchema schema = HollowSchema.readFrom(in);
        int numShards = this.readNumShards(in);
        HollowTypeReadState typeState = this.stateEngine.getTypeState(schema.getName());
        if (typeState != null) {
            if (this.shouldReshard(typeState.numShards(), numShards)) {
                HollowTypeReshardingStrategy reshardingStrategy = HollowTypeReshardingStrategy.getInstance(typeState);
                reshardingStrategy.reshard(typeState, typeState.numShards(), numShards);
            }
            typeState.applyDelta(in, schema, this.stateEngine.getMemoryRecycler(), numShards);
        } else {
            this.discardDelta(in, schema, numShards);
        }
        return schema.getName();
    }

    private boolean shouldReshard(int currNumShards, int deltaNumShards) {
        return currNumShards != 0 && deltaNumShards != 0 && currNumShards != deltaNumShards;
    }

    private int readNumShards(HollowBlobInput in) throws IOException {
        int backwardsCompatibilityBytes = VarInt.readVInt(in);
        if (backwardsCompatibilityBytes == 0) {
            return 1;
        }
        this.skipForwardsCompatibilityBytes(in);
        return VarInt.readVInt(in);
    }

    private void skipForwardsCompatibilityBytes(HollowBlobInput in) throws IOException {
        int skippedBytes;
        for (int bytesToSkip = VarInt.readVInt(in); bytesToSkip > 0; bytesToSkip -= skippedBytes) {
            skippedBytes = (int)in.skipBytes(bytesToSkip);
            if (skippedBytes >= 0) continue;
            throw new EOFException();
        }
    }

    private void discardDelta(HollowBlobInput in, HollowSchema schema, int numShards) throws IOException {
        if (schema instanceof HollowObjectSchema) {
            HollowObjectTypeReadState.discardDelta(in, (HollowObjectSchema)schema, numShards);
        } else if (schema instanceof HollowListSchema) {
            HollowListTypeReadState.discardDelta(in, numShards);
        } else if (schema instanceof HollowSetSchema) {
            HollowSetTypeReadState.discardDelta(in, numShards);
        } else if (schema instanceof HollowMapSchema) {
            HollowMapTypeReadState.discardDelta(in, numShards);
        }
    }

    private void validateMemoryMode(MemoryMode inputMode) {
        if (!this.memoryMode.equals((Object)inputMode)) {
            throw new IllegalStateException(String.format("HollowBlobReader is configured for memory mode %s but HollowBlobInput of mode %s was provided", new Object[]{this.memoryMode, inputMode}));
        }
    }
}

