/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory.pool;

import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;

public class WastefulRecycler
implements ArraySegmentRecycler {
    public static WastefulRecycler DEFAULT_INSTANCE = new WastefulRecycler(11, 8);
    public static WastefulRecycler SMALL_ARRAY_RECYCLER = new WastefulRecycler(5, 2);
    private final int log2OfByteSegmentSize;
    private final int log2OfLongSegmentSize;

    public WastefulRecycler(int log2OfByteSegmentSize, int log2OfLongSegmentSize) {
        this.log2OfByteSegmentSize = log2OfByteSegmentSize;
        this.log2OfLongSegmentSize = log2OfLongSegmentSize;
    }

    @Override
    public int getLog2OfByteSegmentSize() {
        return this.log2OfByteSegmentSize;
    }

    @Override
    public int getLog2OfLongSegmentSize() {
        return this.log2OfLongSegmentSize;
    }

    @Override
    public long[] getLongArray() {
        return new long[(1 << this.log2OfLongSegmentSize) + 1];
    }

    @Override
    public byte[] getByteArray() {
        return new byte[1 << this.log2OfByteSegmentSize];
    }

    @Override
    public void recycleLongArray(long[] arr) {
    }

    @Override
    public void recycleByteArray(byte[] arr) {
    }

    @Override
    public void swap() {
    }
}

