/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory.encoding;

import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.util.IOUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class GapEncodedVariableLengthIntegerReader {
    public static GapEncodedVariableLengthIntegerReader EMPTY_READER = new GapEncodedVariableLengthIntegerReader(null, 0){

        @Override
        public int nextElement() {
            return Integer.MAX_VALUE;
        }
    };
    private final SegmentedByteArray data;
    private final int numBytes;
    private int currentPosition;
    private int nextElement;
    private int elementIndex;

    public GapEncodedVariableLengthIntegerReader(SegmentedByteArray data, int numBytes) {
        this.data = data;
        this.numBytes = numBytes;
        this.reset();
    }

    public boolean isEmpty() {
        return this.numBytes == 0;
    }

    public void advance() {
        if (this.currentPosition == this.numBytes) {
            this.nextElement = Integer.MAX_VALUE;
        } else {
            int nextElementDelta = VarInt.readVInt(this.data, (long)this.currentPosition);
            this.currentPosition += VarInt.sizeOfVInt(nextElementDelta);
            this.nextElement += nextElementDelta;
            ++this.elementIndex;
        }
    }

    public int nextElement() {
        return this.nextElement;
    }

    public int elementIndex() {
        return this.elementIndex;
    }

    public void reset() {
        this.currentPosition = 0;
        this.elementIndex = -1;
        this.nextElement = 0;
        this.advance();
    }

    public int remainingElements() {
        int remainingElementCount = 0;
        while (this.nextElement != Integer.MAX_VALUE) {
            ++remainingElementCount;
            this.advance();
        }
        return remainingElementCount;
    }

    public void destroy() {
        if (this.data != null) {
            this.data.destroy();
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        VarInt.writeVInt(os, this.numBytes);
        this.data.writeTo(os, 0L, this.numBytes);
    }

    public static GapEncodedVariableLengthIntegerReader readEncodedDeltaOrdinals(HollowBlobInput in, ArraySegmentRecycler memoryRecycler) throws IOException {
        SegmentedByteArray arr = new SegmentedByteArray(memoryRecycler);
        long numBytesEncodedOrdinals = VarInt.readVLong(in);
        arr.loadFrom(in, numBytesEncodedOrdinals);
        return new GapEncodedVariableLengthIntegerReader(arr, (int)numBytesEncodedOrdinals);
    }

    public static void copyEncodedDeltaOrdinals(HollowBlobInput in, DataOutputStream ... os) throws IOException {
        long numBytesEncodedOrdinals = IOUtils.copyVLong(in, os);
        IOUtils.copyBytes(in, os, numBytesEncodedOrdinals);
    }

    public static void discardEncodedDeltaOrdinals(HollowBlobInput in) throws IOException {
        for (long numBytesToSkip = VarInt.readVLong(in); numBytesToSkip > 0L; numBytesToSkip -= in.skipBytes(numBytesToSkip)) {
        }
    }

    public static GapEncodedVariableLengthIntegerReader combine(GapEncodedVariableLengthIntegerReader reader1, GapEncodedVariableLengthIntegerReader reader2, ArraySegmentRecycler memoryRecycler) {
        reader1.reset();
        reader2.reset();
        ByteDataArray arr = new ByteDataArray(memoryRecycler);
        int cur = 0;
        while (reader1.nextElement() != Integer.MAX_VALUE || reader2.nextElement() != Integer.MAX_VALUE) {
            if (reader1.nextElement() < reader2.nextElement()) {
                VarInt.writeVInt(arr, reader1.nextElement() - cur);
                cur = reader1.nextElement();
                reader1.advance();
                continue;
            }
            if (reader2.nextElement() < reader1.nextElement()) {
                VarInt.writeVInt(arr, reader2.nextElement() - cur);
                cur = reader2.nextElement();
                reader2.advance();
                continue;
            }
            VarInt.writeVInt(arr, reader1.nextElement() - cur);
            cur = reader1.nextElement();
            reader1.advance();
            reader2.advance();
        }
        return new GapEncodedVariableLengthIntegerReader(arr.getUnderlyingArray(), (int)arr.length());
    }

    public GapEncodedVariableLengthIntegerReader[] split(int numSplits) {
        if (numSplits <= 0 || (numSplits & numSplits - 1) != 0) {
            throw new IllegalStateException("Split should only be called with powers of 2, it was called with " + numSplits);
        }
        int toMask = numSplits - 1;
        int toOrdinalShift = 31 - Integer.numberOfLeadingZeros(numSplits);
        GapEncodedVariableLengthIntegerReader[] to = new GapEncodedVariableLengthIntegerReader[numSplits];
        ArrayList<Integer> ordinals = new ArrayList<Integer>();
        this.reset();
        while (this.nextElement() != Integer.MAX_VALUE) {
            ordinals.add(this.nextElement());
            this.advance();
        }
        ByteDataArray[] splitOrdinals = new ByteDataArray[numSplits];
        int[] previousSplitOrdinal = new int[numSplits];
        Iterator iterator = ordinals.iterator();
        while (iterator.hasNext()) {
            int ordinal = (Integer)iterator.next();
            int toIndex = ordinal & toMask;
            int toOrdinal = ordinal >> toOrdinalShift;
            if (splitOrdinals[toIndex] == null) {
                splitOrdinals[toIndex] = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
            }
            VarInt.writeVInt(splitOrdinals[toIndex], toOrdinal - previousSplitOrdinal[toIndex]);
            previousSplitOrdinal[toIndex] = toOrdinal;
        }
        for (int i = 0; i < numSplits; ++i) {
            to[i] = splitOrdinals[i] == null ? EMPTY_READER : new GapEncodedVariableLengthIntegerReader(splitOrdinals[i].getUnderlyingArray(), (int)splitOrdinals[i].length());
        }
        return to;
    }

    public static GapEncodedVariableLengthIntegerReader join(GapEncodedVariableLengthIntegerReader[] from) {
        if (from == null) {
            throw new IllegalStateException("Join invoked on a null input array");
        }
        if (from.length <= 0 || (from.length & from.length - 1) != 0) {
            throw new IllegalStateException("Join should only be called with powers of 2, it was called with " + from.length);
        }
        int numSplits = from.length;
        int fromMask = numSplits - 1;
        int fromOrdinalShift = 31 - Integer.numberOfLeadingZeros(numSplits);
        int joinedMaxOrdinal = -1;
        HashSet[] fromOrdinals = new HashSet[from.length];
        for (int i = 0; i < from.length; ++i) {
            fromOrdinals[i] = new HashSet();
            if (from[i] == null) continue;
            from[i].reset();
            while (from[i].nextElement() != Integer.MAX_VALUE) {
                int splitOrdinal = from[i].nextElement();
                fromOrdinals[i].add(splitOrdinal);
                joinedMaxOrdinal = Math.max(joinedMaxOrdinal, splitOrdinal * numSplits + i);
                from[i].advance();
            }
        }
        ByteDataArray toRemovals = null;
        int previousOrdinal = 0;
        for (int ordinal = 0; ordinal <= joinedMaxOrdinal; ++ordinal) {
            int fromIndex = ordinal & fromMask;
            int fromOrdinal = ordinal >> fromOrdinalShift;
            if (!fromOrdinals[fromIndex].contains(fromOrdinal)) continue;
            if (toRemovals == null) {
                toRemovals = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
            }
            VarInt.writeVInt(toRemovals, ordinal - previousOrdinal);
            previousOrdinal = ordinal;
        }
        if (toRemovals == null) {
            return EMPTY_READER;
        }
        return new GapEncodedVariableLengthIntegerReader(toRemovals.getUnderlyingArray(), (int)toRemovals.length());
    }
}

