/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.memory;

import com.netflix.hollow.core.memory.HollowUnsafeHandle;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import java.io.DataOutputStream;
import java.io.IOException;
import sun.misc.Unsafe;

public class SegmentedLongArray {
    private static final Unsafe unsafe = HollowUnsafeHandle.getUnsafe();
    protected final long[][] segments;
    protected final int log2OfSegmentSize;
    protected final int bitmask;

    public SegmentedLongArray(ArraySegmentRecycler memoryRecycler, long numLongs) {
        this.log2OfSegmentSize = memoryRecycler.getLog2OfLongSegmentSize();
        int numSegments = (int)(numLongs - 1L >>> this.log2OfSegmentSize) + 1;
        long[][] segments = new long[numSegments][];
        this.bitmask = (1 << this.log2OfSegmentSize) - 1;
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = memoryRecycler.getLongArray();
        }
        this.segments = segments;
    }

    public void set(long index, long value) {
        int segmentIndex = (int)(index >> this.log2OfSegmentSize);
        int longInSegment = (int)(index & (long)this.bitmask);
        unsafe.putLong(this.segments[segmentIndex], (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (long)(8 * longInSegment), value);
        if (longInSegment == 0 && segmentIndex != 0) {
            unsafe.putLong(this.segments[segmentIndex - 1], (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (long)(8 * (1 << this.log2OfSegmentSize)), value);
        }
    }

    public long get(long index) {
        int segmentIndex = (int)(index >>> this.log2OfSegmentSize);
        long ret = this.segments[segmentIndex][(int)(index & (long)this.bitmask)];
        return ret;
    }

    public void fill(long value) {
        for (int i = 0; i < this.segments.length; ++i) {
            long offset = Unsafe.ARRAY_LONG_BASE_OFFSET;
            for (int j = 0; j < this.segments[i].length; ++j) {
                unsafe.putLong(this.segments[i], offset, value);
                offset += 8L;
            }
        }
    }

    public void writeTo(DataOutputStream dos, long numLongs) throws IOException {
        VarInt.writeVLong(dos, numLongs);
        for (long i = 0L; i < numLongs; ++i) {
            dos.writeLong(this.get(i));
        }
    }

    public void destroy(ArraySegmentRecycler memoryRecycler) {
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] == null) continue;
            memoryRecycler.recycleLongArray(this.segments[i]);
        }
    }

    protected void readFrom(HollowBlobInput in, ArraySegmentRecycler memoryRecycler, long numLongs) throws IOException {
        int segmentSize = 1 << memoryRecycler.getLog2OfLongSegmentSize();
        int segment = 0;
        if (numLongs == 0L) {
            return;
        }
        long fencepostLong = in.readLong();
        while (numLongs > 0L) {
            long longsToCopy = Math.min((long)segmentSize, numLongs);
            unsafe.putLong(this.segments[segment], Unsafe.ARRAY_LONG_BASE_OFFSET, fencepostLong);
            int longsCopied = 1;
            while ((long)longsCopied < longsToCopy) {
                long l = in.readLong();
                unsafe.putLong(this.segments[segment], (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (long)(8 * longsCopied++), l);
            }
            if (numLongs > (long)longsCopied) {
                unsafe.putLong(this.segments[segment], (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (long)(8 * longsCopied), in.readLong());
                fencepostLong = this.segments[segment][longsCopied];
            }
            ++segment;
            numLongs -= (long)longsCopied;
        }
    }
}

