/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index.traversal;

import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.util.IntList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

abstract class HollowIndexerTraversalNode {
    protected final HollowTypeDataAccess dataAccess;
    protected final IntList[] fieldMatches;
    protected int indexedFieldPosition = -1;
    protected final Map<String, HollowIndexerTraversalNode> children;
    private boolean shouldMultiplyBranchResults;
    private int[] childrenRepeatCounts;
    private int[] childrenMatchCounts;
    private int[] fieldChildMap;
    private int[] childFirstFieldMap;
    private int currentMultiplyFieldMatchListPosition;

    public HollowIndexerTraversalNode(HollowTypeDataAccess dataAccess, IntList[] fieldMatches) {
        this.dataAccess = dataAccess;
        this.fieldMatches = fieldMatches;
        this.children = new HashMap<String, HollowIndexerTraversalNode>();
    }

    public void setIndexedFieldPosition(int indexedFieldPosition) {
        this.indexedFieldPosition = indexedFieldPosition;
    }

    public int getIndexedFieldPosition() {
        return this.indexedFieldPosition;
    }

    public IntList setUpMultiplication() {
        this.shouldMultiplyBranchResults = this.shouldMultiplyBranchResults();
        this.childrenRepeatCounts = new int[this.children.size()];
        this.childrenMatchCounts = new int[this.children.size()];
        this.fieldChildMap = new int[this.fieldMatches.length];
        this.childFirstFieldMap = new int[this.children.size()];
        Arrays.fill(this.fieldChildMap, -1);
        IntList branchFieldPositions = new IntList();
        if (this.indexedFieldPosition != -1) {
            branchFieldPositions.add(this.indexedFieldPosition);
        }
        int childCounter = 0;
        for (Map.Entry<String, HollowIndexerTraversalNode> entry : this.children.entrySet()) {
            IntList childBranchFieldPositions = entry.getValue().setUpMultiplication();
            this.childFirstFieldMap[childCounter] = childBranchFieldPositions.get(0);
            for (int i = 0; i < childBranchFieldPositions.size(); ++i) {
                this.fieldChildMap[childBranchFieldPositions.get((int)i)] = childCounter;
                branchFieldPositions.add(childBranchFieldPositions.get(i));
            }
            ++childCounter;
        }
        return branchFieldPositions;
    }

    public void traverse(int ordinal) {
        if (this.childFirstFieldMap.length == 0) {
            this.doTraversal(ordinal);
            if (this.indexedFieldPosition != -1) {
                this.fieldMatches[this.indexedFieldPosition].add(ordinal);
            }
        } else {
            int childMatchSize = this.doTraversal(ordinal);
            if (this.indexedFieldPosition != -1) {
                for (int i = 0; i < childMatchSize; ++i) {
                    this.fieldMatches[this.indexedFieldPosition].add(ordinal);
                }
            }
        }
    }

    public void prepareMultiply() {
        if (this.childFirstFieldMap.length > 0) {
            this.currentMultiplyFieldMatchListPosition = this.fieldMatches[this.childFirstFieldMap[0]].size();
        }
    }

    public int doMultiply() {
        if (this.shouldMultiplyBranchResults) {
            int i;
            int nextRepeatCount = 1;
            for (i = 0; i < this.childrenMatchCounts.length; ++i) {
                this.childrenMatchCounts[i] = this.fieldMatches[this.childFirstFieldMap[i]].size() - this.currentMultiplyFieldMatchListPosition;
                this.childrenRepeatCounts[i] = nextRepeatCount;
                nextRepeatCount *= this.childrenMatchCounts[i];
            }
            if (nextRepeatCount == 0) {
                for (i = 0; i < this.childrenMatchCounts.length; ++i) {
                    this.fieldMatches[this.childFirstFieldMap[i]].expandTo(this.currentMultiplyFieldMatchListPosition);
                }
                return 0;
            }
            int newFieldMatchListPosition = this.currentMultiplyFieldMatchListPosition + nextRepeatCount;
            for (int i2 = 0; i2 < this.fieldMatches.length; ++i2) {
                int startCopyFromIdx;
                if (this.fieldChildMap[i2] == -1) continue;
                this.fieldMatches[i2].expandTo(newFieldMatchListPosition);
                int currentCopyToIdx = newFieldMatchListPosition - 1;
                int currentCopyFromIdx = startCopyFromIdx = this.currentMultiplyFieldMatchListPosition + this.childrenMatchCounts[this.fieldChildMap[i2]] - 1;
                while (currentCopyToIdx > this.currentMultiplyFieldMatchListPosition) {
                    for (int j = 0; j < this.childrenRepeatCounts[this.fieldChildMap[i2]]; ++j) {
                        this.fieldMatches[i2].set(currentCopyToIdx, this.fieldMatches[i2].get(currentCopyFromIdx));
                        --currentCopyToIdx;
                    }
                    if (--currentCopyFromIdx >= this.currentMultiplyFieldMatchListPosition) continue;
                    currentCopyFromIdx = startCopyFromIdx;
                }
            }
            return nextRepeatCount;
        }
        if (this.childFirstFieldMap.length != 0) {
            return this.fieldMatches[this.childFirstFieldMap[0]].size() - this.currentMultiplyFieldMatchListPosition;
        }
        return 1;
    }

    public abstract int doTraversal(int var1);

    protected abstract HollowTypeDataAccess dataAccess();

    protected abstract void setUpChildren();

    protected abstract boolean followingChildrenMultipliesTraversal();

    HollowIndexerTraversalNode getChild(String name) {
        return this.children.get(name);
    }

    void addChild(String name, HollowIndexerTraversalNode child) {
        this.children.put(name, child);
    }

    private boolean shouldMultiplyBranchResults() {
        if (this.children.size() > 1) {
            for (Map.Entry<String, HollowIndexerTraversalNode> entry : this.children.entrySet()) {
                if (!entry.getValue().branchMayProduceMoreThanOneMatch()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean branchMayProduceMoreThanOneMatch() {
        if (!this.children.isEmpty() && this.followingChildrenMultipliesTraversal()) {
            return true;
        }
        for (Map.Entry<String, HollowIndexerTraversalNode> entry : this.children.entrySet()) {
            if (!entry.getValue().branchMayProduceMoreThanOneMatch()) continue;
            return true;
        }
        return false;
    }
}

