/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index.traversal;

import com.netflix.hollow.core.index.traversal.HollowIndexerObjectFieldTraversalNode;
import com.netflix.hollow.core.index.traversal.HollowIndexerTraversalNode;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.util.IntList;
import java.util.Map;

class HollowIndexerObjectTraversalNode
extends HollowIndexerTraversalNode {
    protected HollowIndexerTraversalNode[] children;
    protected int[] childOrdinalFieldPositions;

    public HollowIndexerObjectTraversalNode(HollowObjectTypeDataAccess dataAccess, IntList[] fieldMatches) {
        super(dataAccess, fieldMatches);
    }

    @Override
    protected void setUpChildren() {
        this.children = new HollowIndexerTraversalNode[((HollowIndexerTraversalNode)this).children.size()];
        this.childOrdinalFieldPositions = new int[this.children.length];
        int idx = 0;
        for (Map.Entry<String, HollowIndexerTraversalNode> entry : ((HollowIndexerTraversalNode)this).children.entrySet()) {
            this.childOrdinalFieldPositions[idx] = this.dataAccess().getSchema().getPosition(entry.getKey());
            this.children[idx] = entry.getValue();
            ++idx;
        }
    }

    @Override
    public int doTraversal(int ordinal) {
        this.prepareMultiply();
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] instanceof HollowIndexerObjectFieldTraversalNode) {
                this.children[i].traverse(ordinal);
                continue;
            }
            int childOrdinal = this.dataAccess().readOrdinal(ordinal, this.childOrdinalFieldPositions[i]);
            if (childOrdinal == -1) continue;
            this.children[i].traverse(childOrdinal);
        }
        return this.doMultiply();
    }

    @Override
    protected HollowObjectTypeDataAccess dataAccess() {
        return (HollowObjectTypeDataAccess)this.dataAccess;
    }

    @Override
    protected boolean followingChildrenMultipliesTraversal() {
        return false;
    }
}

