/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index.key;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.Arrays;

public class HollowPrimaryKeyValueDeriver {
    private final HollowObjectTypeReadState typeState;
    private final int[][] fieldPathIndexes;
    private final HollowObjectSchema.FieldType[] fieldTypes;

    public HollowPrimaryKeyValueDeriver(PrimaryKey primaryKey, HollowReadStateEngine stateEngine) {
        this.fieldPathIndexes = new int[primaryKey.numFields()][];
        this.fieldTypes = new HollowObjectSchema.FieldType[primaryKey.numFields()];
        for (int i = 0; i < primaryKey.numFields(); ++i) {
            this.fieldPathIndexes[i] = primaryKey.getFieldPathIndex(stateEngine, i);
            this.fieldTypes[i] = primaryKey.getFieldType(stateEngine, i);
        }
        this.typeState = (HollowObjectTypeReadState)stateEngine.getTypeState(primaryKey.getType());
    }

    public HollowPrimaryKeyValueDeriver(HollowObjectTypeReadState typeState, int[][] fieldPathIndexes, HollowObjectSchema.FieldType[] fieldTypes) {
        this.typeState = typeState;
        this.fieldPathIndexes = fieldPathIndexes;
        this.fieldTypes = fieldTypes;
    }

    public boolean keyMatches(int ordinal, Object ... keys) {
        if (keys.length != this.fieldPathIndexes.length) {
            return false;
        }
        for (int i = 0; i < keys.length; ++i) {
            if (this.keyMatches(keys[i], ordinal, i)) continue;
            return false;
        }
        return true;
    }

    public boolean keyMatches(Object key, int ordinal, int fieldIdx) {
        HollowObjectTypeReadState typeState = this.typeState;
        HollowObjectSchema schema = typeState.getSchema();
        int lastFieldPath = this.fieldPathIndexes[fieldIdx].length - 1;
        for (int i = 0; i < lastFieldPath; ++i) {
            int fieldPosition = this.fieldPathIndexes[fieldIdx][i];
            ordinal = typeState.readOrdinal(ordinal, fieldPosition);
            typeState = (HollowObjectTypeReadState)schema.getReferencedTypeState(fieldPosition);
            schema = typeState.getSchema();
        }
        int lastFieldIdx = this.fieldPathIndexes[fieldIdx][lastFieldPath];
        return HollowPrimaryKeyValueDeriver.keyMatches(key, this.fieldTypes[fieldIdx], lastFieldIdx, ordinal, typeState);
    }

    public static boolean keyMatches(Object key, HollowObjectSchema.FieldType fieldType, int lastFieldIdx, int ordinal, HollowObjectTypeDataAccess dataAccess) {
        switch (fieldType) {
            case BOOLEAN: {
                Boolean b = dataAccess.readBoolean(ordinal, lastFieldIdx);
                if (b == key) {
                    return true;
                }
                if (b == null || key == null) {
                    return false;
                }
                return b.booleanValue() == ((Boolean)key).booleanValue();
            }
            case BYTES: {
                return Arrays.equals(dataAccess.readBytes(ordinal, lastFieldIdx), (byte[])key);
            }
            case DOUBLE: {
                return dataAccess.readDouble(ordinal, lastFieldIdx) == ((Double)key).doubleValue();
            }
            case FLOAT: {
                return dataAccess.readFloat(ordinal, lastFieldIdx) == ((Float)key).floatValue();
            }
            case INT: {
                return dataAccess.readInt(ordinal, lastFieldIdx) == ((Integer)key).intValue();
            }
            case LONG: {
                return dataAccess.readLong(ordinal, lastFieldIdx) == ((Long)key).longValue();
            }
            case REFERENCE: {
                return dataAccess.readOrdinal(ordinal, lastFieldIdx) == ((Integer)key).intValue();
            }
            case STRING: {
                return dataAccess.isStringFieldEqual(ordinal, lastFieldIdx, (String)key);
            }
        }
        throw new IllegalArgumentException("I don't know how to compare a " + (Object)((Object)fieldType));
    }

    public Object[] getRecordKey(int ordinal) {
        Object[] results = new Object[this.fieldPathIndexes.length];
        for (int i = 0; i < this.fieldPathIndexes.length; ++i) {
            results[i] = this.readValue(ordinal, i);
        }
        return results;
    }

    private Object readValue(int ordinal, int fieldIdx) {
        HollowObjectTypeReadState typeState = this.typeState;
        HollowObjectSchema schema = typeState.getSchema();
        int lastFieldPath = this.fieldPathIndexes[fieldIdx].length - 1;
        for (int i = 0; i < lastFieldPath; ++i) {
            int fieldPosition = this.fieldPathIndexes[fieldIdx][i];
            ordinal = typeState.readOrdinal(ordinal, fieldPosition);
            typeState = (HollowObjectTypeReadState)schema.getReferencedTypeState(fieldPosition);
            schema = typeState.getSchema();
        }
        return HollowReadFieldUtils.fieldValueObject(typeState, ordinal, this.fieldPathIndexes[fieldIdx][lastFieldPath]);
    }

    public int[][] getFieldPathIndexes() {
        return this.fieldPathIndexes;
    }

    public HollowObjectSchema.FieldType[] getFieldTypes() {
        return this.fieldTypes;
    }
}

