/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.index.GrowingSegmentedLongArray;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;

public class MultiLinkedElementArray {
    private final GrowingSegmentedLongArray listPointersAndSizes;
    private final GrowingSegmentedLongArray linkedElements;
    private int nextNewPointer = 0;
    private long nextLinkedElement = 0L;

    public MultiLinkedElementArray(ArraySegmentRecycler memoryRecycler) {
        this.listPointersAndSizes = new GrowingSegmentedLongArray(memoryRecycler);
        this.linkedElements = new GrowingSegmentedLongArray(memoryRecycler);
    }

    public HollowOrdinalIterator iterator(int listIdx) {
        if ((this.listPointersAndSizes.get(listIdx) & Long.MIN_VALUE) != 0L) {
            return new PivotedElementIterator(listIdx);
        }
        return new LinkedElementIterator(listIdx);
    }

    public void add(int listIdx, int value) {
        long listPtr = this.listPointersAndSizes.get(listIdx);
        if (listPtr == 0L) {
            this.listPointersAndSizes.set(listIdx, Long.MIN_VALUE | (long)value << 32);
            return;
        }
        if ((listPtr & 0xFFFFFFFFL) == 0L) {
            this.listPointersAndSizes.set(listIdx, listPtr | 0x80000000L | (long)value);
            return;
        }
        if ((listPtr & Long.MIN_VALUE) != 0L) {
            this.linkedElements.set(this.nextLinkedElement, listPtr);
            long newLink = (long)value << 32 | this.nextLinkedElement;
            this.linkedElements.set(++this.nextLinkedElement, newLink);
            listPtr = this.nextLinkedElement++ << 32 | 3L;
            this.listPointersAndSizes.set(listIdx, listPtr);
        } else {
            long linkedElement = listPtr >> 32;
            long size = listPtr & Integer.MAX_VALUE;
            long newLink = (long)value << 32 | linkedElement;
            this.linkedElements.set(this.nextLinkedElement, newLink);
            listPtr = this.nextLinkedElement++ << 32 | size + 1L;
            this.listPointersAndSizes.set(listIdx, listPtr);
        }
    }

    public int numLists() {
        return this.nextNewPointer;
    }

    public int newList() {
        return this.nextNewPointer++;
    }

    public int listSize(int listIdx) {
        long listPtr = this.listPointersAndSizes.get(listIdx);
        if (listPtr == 0L) {
            return 0;
        }
        if ((listPtr & Long.MIN_VALUE) != 0L) {
            return (listPtr & 0xFFFFFFFFL) == 0L ? 1 : 2;
        }
        return (int)(listPtr & Integer.MAX_VALUE);
    }

    public void destroy() {
        this.listPointersAndSizes.destroy();
        this.linkedElements.destroy();
    }

    public class PivotedElementIterator
    implements HollowOrdinalIterator {
        private int listIdx;
        private int currentElement;

        private PivotedElementIterator(int listIdx) {
            this.listIdx = listIdx;
        }

        @Override
        public int next() {
            if (this.currentElement > 1) {
                return Integer.MAX_VALUE;
            }
            long element = MultiLinkedElementArray.this.listPointersAndSizes.get(this.listIdx);
            if (this.currentElement++ == 0 && (element & 0xFFFFFFFFL) != 0L) {
                return (int)element & Integer.MAX_VALUE;
            }
            ++this.currentElement;
            return (int)(element >>> 32) & Integer.MAX_VALUE;
        }
    }

    public class LinkedElementIterator
    implements HollowOrdinalIterator {
        private int currentElement;
        private boolean lastElement;
        private boolean finished;

        private LinkedElementIterator(int listIdx) {
            this.currentElement = (int)(MultiLinkedElementArray.this.listPointersAndSizes.get(listIdx) >> 32);
        }

        @Override
        public int next() {
            if (this.finished) {
                return Integer.MAX_VALUE;
            }
            if (this.lastElement) {
                int value = (int)(MultiLinkedElementArray.this.linkedElements.get(this.currentElement) >>> 32) & Integer.MAX_VALUE;
                this.finished = true;
                return value;
            }
            long element = MultiLinkedElementArray.this.linkedElements.get(this.currentElement);
            if (element < 0L) {
                this.lastElement = true;
                return (int)element & Integer.MAX_VALUE;
            }
            this.currentElement = (int)element;
            return (int)(element >> 32);
        }
    }
}

