/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core;

import com.netflix.hollow.api.error.SchemaNotFoundException;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.List;

public interface HollowDataset {
    public List<HollowSchema> getSchemas();

    public HollowSchema getSchema(String var1);

    public HollowSchema getNonNullSchema(String var1) throws SchemaNotFoundException;

    default public boolean hasIdenticalSchemas(HollowDataset other) {
        List<HollowSchema> thisSchemas = this.getSchemas();
        List<HollowSchema> otherSchemas = other.getSchemas();
        if (thisSchemas.size() != otherSchemas.size()) {
            return false;
        }
        for (HollowSchema thisSchema : thisSchemas) {
            HollowSchema otherSchema = other.getSchema(thisSchema.getName());
            if (otherSchema != null && thisSchema.equals(otherSchema)) continue;
            return false;
        }
        return true;
    }
}

