/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core;

import com.netflix.hollow.core.schema.HollowSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HollowBlobHeader {
    public static final int HOLLOW_BLOB_VERSION_HEADER = 1030;
    private Map<String, String> headerTags = new HashMap<String, String>();
    private List<HollowSchema> schemas = new ArrayList<HollowSchema>();
    private long originRandomizedTag;
    private long destinationRandomizedTag;
    private int blobFormatVersion = 1030;

    public Map<String, String> getHeaderTags() {
        return this.headerTags;
    }

    public void setSchemas(List<HollowSchema> schemas) {
        this.schemas = schemas;
    }

    public List<HollowSchema> getSchemas() {
        return this.schemas;
    }

    public void setHeaderTags(Map<String, String> headerTags) {
        this.headerTags = headerTags;
    }

    public long getOriginRandomizedTag() {
        return this.originRandomizedTag;
    }

    public void setOriginRandomizedTag(long originRandomizedTag) {
        this.originRandomizedTag = originRandomizedTag;
    }

    public long getDestinationRandomizedTag() {
        return this.destinationRandomizedTag;
    }

    public void setDestinationRandomizedTag(long destinationRandomizedTag) {
        this.destinationRandomizedTag = destinationRandomizedTag;
    }

    public void setBlobFormatVersion(int blobFormatVersion) {
        this.blobFormatVersion = blobFormatVersion;
    }

    public int getBlobFormatVersion() {
        return this.blobFormatVersion;
    }

    public boolean equals(Object other) {
        if (other instanceof HollowBlobHeader) {
            HollowBlobHeader oh = (HollowBlobHeader)other;
            return this.blobFormatVersion == oh.blobFormatVersion && this.headerTags.equals(oh.getHeaderTags()) && this.originRandomizedTag == oh.originRandomizedTag && this.destinationRandomizedTag == oh.destinationRandomizedTag;
        }
        return false;
    }

    public int hashCode() {
        int result = this.blobFormatVersion;
        result = 31 * result + Objects.hash(this.headerTags, this.originRandomizedTag, this.destinationRandomizedTag, this.blobFormatVersion);
        return result;
    }
}

