/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.testdata;

import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.write.HollowListTypeWriteState;
import com.netflix.hollow.core.write.HollowMapTypeWriteState;
import com.netflix.hollow.core.write.HollowObjectTypeWriteState;
import com.netflix.hollow.core.write.HollowSetTypeWriteState;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;

public abstract class HollowTestRecord<T> {
    private final T parent;
    private int assignedOrdinal = -1;

    protected HollowTestRecord(T parent) {
        this.parent = parent;
    }

    public T up() {
        return this.parent;
    }

    public <T> T upTop() {
        HollowTestRecord root = this;
        while (root.up() != null) {
            root = (HollowTestRecord)root.up();
        }
        return (T)root;
    }

    int addTo(HollowWriteStateEngine writeEngine) {
        HollowSchema schema = this.getSchema();
        HollowTypeWriteState typeState = writeEngine.getTypeState(schema.getName());
        if (typeState == null) {
            switch (schema.getSchemaType()) {
                case OBJECT: {
                    typeState = new HollowObjectTypeWriteState((HollowObjectSchema)schema);
                    break;
                }
                case LIST: {
                    typeState = new HollowListTypeWriteState((HollowListSchema)schema);
                    break;
                }
                case SET: {
                    typeState = new HollowSetTypeWriteState((HollowSetSchema)schema);
                    break;
                }
                case MAP: {
                    typeState = new HollowMapTypeWriteState((HollowMapSchema)schema);
                }
            }
            writeEngine.addTypeState(typeState);
        }
        this.assignedOrdinal = typeState.add(this.toWriteRecord(writeEngine));
        return this.assignedOrdinal;
    }

    public int getOrdinal() {
        return this.assignedOrdinal;
    }

    protected abstract HollowSchema getSchema();

    protected abstract HollowWriteRecord toWriteRecord(HollowWriteStateEngine var1);
}

