/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.testdata;

import com.netflix.hollow.api.testdata.HollowTestRecord;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import java.util.HashMap;
import java.util.Map;

public abstract class HollowTestObjectRecord<T>
extends HollowTestRecord<T> {
    private final Map<String, Field> fields = new HashMap<String, Field>();

    protected HollowTestObjectRecord(T parent) {
        super(parent);
    }

    protected void addField(String fieldName, Object value) {
        if (value == null) {
            this.fields.remove(fieldName);
        } else {
            this.addField(new Field(fieldName, value));
        }
    }

    protected void addField(Field field) {
        if (field.value == null) {
            this.fields.remove(field.name);
        } else {
            this.fields.put(field.name, field);
        }
    }

    protected Field getField(String name) {
        return this.fields.get(name);
    }

    @Override
    protected HollowWriteRecord toWriteRecord(HollowWriteStateEngine writeEngine) {
        HollowObjectWriteRecord rec = new HollowObjectWriteRecord(this.getSchema());
        for (Map.Entry<String, Field> entry : this.fields.entrySet()) {
            Field field = entry.getValue();
            if (field.value instanceof Integer) {
                rec.setInt(field.name, (Integer)field.value);
                continue;
            }
            if (field.value instanceof Long) {
                rec.setLong(field.name, (Long)field.value);
                continue;
            }
            if (field.value instanceof Float) {
                rec.setFloat(field.name, ((Float)field.value).floatValue());
                continue;
            }
            if (field.value instanceof Boolean) {
                rec.setBoolean(field.name, (Boolean)field.value);
                continue;
            }
            if (field.value instanceof String) {
                rec.setString(field.name, (String)field.value);
                continue;
            }
            if (field.value instanceof byte[]) {
                rec.setBytes(field.name, (byte[])field.value);
                continue;
            }
            if (field.value instanceof HollowTestRecord) {
                rec.setReference(field.name, ((HollowTestRecord)field.value).addTo(writeEngine));
                continue;
            }
            throw new IllegalStateException("Unknown field type: " + field.value.getClass());
        }
        return rec;
    }

    @Override
    protected abstract HollowObjectSchema getSchema();

    protected static class Field {
        public final String name;
        public final Object value;

        public Field(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

