/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.sampling;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.api.sampling.SampleResult;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class HollowObjectSampler
implements HollowSampler {
    public static final HollowObjectSampler NULL_SAMPLER = new HollowObjectSampler(new HollowObjectSchema("test", 0, new String[0]), DisabledSamplingDirector.INSTANCE);
    private final String typeName;
    private final String[] fieldNames;
    private final long[] sampleCounts;
    private final HollowSamplingDirector[] samplingDirectors;
    private boolean isSamplingDisabled;

    public HollowObjectSampler(HollowObjectSchema schema, HollowSamplingDirector director) {
        this.typeName = schema.getName();
        this.sampleCounts = new long[schema.numFields()];
        this.isSamplingDisabled = director == DisabledSamplingDirector.INSTANCE;
        Object[] samplingDirectors = new HollowSamplingDirector[schema.numFields()];
        Arrays.fill(samplingDirectors, director);
        String[] fieldNames = new String[schema.numFields()];
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = schema.getFieldName(i);
        }
        this.fieldNames = fieldNames;
        this.samplingDirectors = samplingDirectors;
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
        if (!"".equals(this.typeName)) {
            this.isSamplingDisabled = director == DisabledSamplingDirector.INSTANCE;
            Arrays.fill(this.samplingDirectors, director);
        }
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        HollowFilterConfig.ObjectFilterConfig typeConfig = fieldSpec.getObjectTypeConfig(this.typeName);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!typeConfig.includesField(this.fieldNames[i])) continue;
            this.isSamplingDisabled = false;
            this.samplingDirectors[i] = director;
        }
    }

    @Override
    public void setUpdateThread(Thread t) {
        for (int i = 0; i < this.samplingDirectors.length; ++i) {
            this.samplingDirectors[i].setUpdateThread(t);
        }
    }

    public void recordFieldAccess(int fieldPosition) {
        if (this.isSamplingDisabled) {
            return;
        }
        if (this.samplingDirectors[fieldPosition].shouldRecord()) {
            int n = fieldPosition;
            this.sampleCounts[n] = this.sampleCounts[n] + 1L;
        }
    }

    @Override
    public boolean hasSampleResults() {
        for (int i = 0; i < this.sampleCounts.length; ++i) {
            if (this.sampleCounts[i] <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<SampleResult> getSampleResults() {
        ArrayList<SampleResult> sampleResults = new ArrayList<SampleResult>(this.sampleCounts.length);
        for (int i = 0; i < this.sampleCounts.length; ++i) {
            sampleResults.add(new SampleResult(this.typeName + "." + this.fieldNames[i], this.sampleCounts[i]));
        }
        return sampleResults;
    }

    @Override
    public void reset() {
        Arrays.fill(this.sampleCounts, 0L);
    }
}

