/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.validation;

import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.validation.ValidationResult;
import com.netflix.hollow.api.producer.validation.ValidatorListener;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.objectmapper.HollowPrimaryKey;
import com.netflix.hollow.core.write.objectmapper.HollowTypeMapper;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class NullPrimaryKeyFieldValidator
implements ValidatorListener {
    private static final String NAME = NullPrimaryKeyFieldValidator.class.getName();
    private static final String NULL_PRIMARY_KEYS_FOUND_ERROR_MSG_FORMAT = "Null primary key fields found for type %s. Primary Key in schema is %s. Null records: [%s]";
    private static final String NO_PRIMARY_KEY_ERROR_MSG_FORMAT = "NullPrimaryKeyFieldValidator defined but unable to find primary key for data type %s. Please check schema definition.";
    private static final String NO_SCHEMA_FOUND_MSG_FORMAT = "NullPrimaryKeyFieldValidator defined for data type %s but schema not found. Please check that the HollowProducer is initialized with the data type's schema (see initializeDataModel)";
    private static final String NOT_AN_OBJECT_ERROR_MSG_FORMAT = "NullPrimaryKeyFieldValidator is defined but schema type of %s is not Object. This validation cannot be done.";
    private static final String FIELD_PATH_NAME = "FieldPaths";
    private static final String DATA_TYPE_NAME = "Typename";
    private final String dataTypeName;

    public NullPrimaryKeyFieldValidator(Class<?> dataType) {
        Objects.requireNonNull(dataType);
        if (!dataType.isAnnotationPresent(HollowPrimaryKey.class)) {
            throw new IllegalArgumentException("The data class " + dataType.getName() + " must be annotated with @HollowPrimaryKey");
        }
        this.dataTypeName = HollowTypeMapper.getDefaultTypeName(dataType);
    }

    public NullPrimaryKeyFieldValidator(String dataTypeName) {
        this.dataTypeName = Objects.requireNonNull(dataTypeName);
    }

    @Override
    public String getName() {
        return NAME + "_" + this.dataTypeName;
    }

    @Override
    public ValidationResult onValidate(HollowProducer.ReadState readState) {
        ValidationResult.ValidationResultBuilder vrb = ValidationResult.from(this);
        vrb.detail(DATA_TYPE_NAME, this.dataTypeName);
        HollowSchema schema = readState.getStateEngine().getSchema(this.dataTypeName);
        if (schema == null) {
            return vrb.failed(String.format(NO_SCHEMA_FOUND_MSG_FORMAT, this.dataTypeName));
        }
        if (schema.getSchemaType() != HollowSchema.SchemaType.OBJECT) {
            return vrb.failed(String.format(NOT_AN_OBJECT_ERROR_MSG_FORMAT, this.dataTypeName));
        }
        HollowObjectSchema oSchema = (HollowObjectSchema)schema;
        PrimaryKey primaryKey = oSchema.getPrimaryKey();
        if (primaryKey == null) {
            return vrb.failed(String.format(NO_PRIMARY_KEY_ERROR_MSG_FORMAT, this.dataTypeName));
        }
        String fieldPaths = Arrays.toString(primaryKey.getFieldPaths());
        vrb.detail(FIELD_PATH_NAME, fieldPaths);
        Map<Integer, Object[]> ordinalToNullPkey = this.getNullPrimaryKeyValues(readState, primaryKey);
        if (!ordinalToNullPkey.isEmpty()) {
            return vrb.failed(String.format(NULL_PRIMARY_KEYS_FOUND_ERROR_MSG_FORMAT, this.dataTypeName, fieldPaths, this.nullKeysToString(ordinalToNullPkey)));
        }
        return vrb.passed(this.getName() + "no records with null primary key fields");
    }

    private Map<Integer, Object[]> getNullPrimaryKeyValues(HollowProducer.ReadState readState, PrimaryKey primaryKey) {
        HollowReadStateEngine stateEngine = readState.getStateEngine();
        HollowObjectTypeReadState typeState = (HollowObjectTypeReadState)stateEngine.getTypeState(this.dataTypeName);
        int[][] fieldPathIndexes = new int[primaryKey.getFieldPaths().length][];
        for (int i = 0; i < fieldPathIndexes.length; ++i) {
            fieldPathIndexes[i] = primaryKey.getFieldPathIndex(stateEngine, i);
        }
        BitSet ordinals = typeState.getPopulatedOrdinals();
        int ordinal = ordinals.nextSetBit(0);
        HashMap<Integer, Object[]> ordinalToNullPkey = new HashMap<Integer, Object[]>();
        while (ordinal != -1) {
            Object[] primaryKeyValues = this.getPrimaryKeyValue(typeState, fieldPathIndexes, ordinal);
            if (Arrays.stream(primaryKeyValues).anyMatch(Objects::isNull)) {
                ordinalToNullPkey.put(ordinal, primaryKeyValues);
            }
            ordinal = ordinals.nextSetBit(ordinal + 1);
        }
        return ordinalToNullPkey;
    }

    private Object[] getPrimaryKeyValue(HollowObjectTypeReadState typeState, int[][] fieldPathIndexes, int ordinal) {
        Object[] results = new Object[fieldPathIndexes.length];
        for (int i = 0; i < fieldPathIndexes.length; ++i) {
            results[i] = this.getPrimaryKeyFieldValue(typeState, fieldPathIndexes[i], ordinal);
        }
        return results;
    }

    private Object getPrimaryKeyFieldValue(HollowObjectTypeReadState typeState, int[] fieldPathIndexes, int ordinal) {
        HollowObjectSchema schema = typeState.getSchema();
        int lastFieldPath = fieldPathIndexes.length - 1;
        for (int i = 0; i < lastFieldPath; ++i) {
            if (ordinal == -1) {
                return null;
            }
            ordinal = typeState.readOrdinal(ordinal, fieldPathIndexes[i]);
            typeState = (HollowObjectTypeReadState)schema.getReferencedTypeState(fieldPathIndexes[i]);
            schema = typeState.getSchema();
        }
        if (ordinal == -1) {
            return null;
        }
        return HollowReadFieldUtils.fieldValueObject(typeState, ordinal, fieldPathIndexes[lastFieldPath]);
    }

    private String nullKeysToString(Map<Integer, Object[]> nullPrimaryKeyValues) {
        return nullPrimaryKeyValues.entrySet().stream().map(entry -> "(ordinal=" + entry.getKey() + ", key=" + Arrays.toString((Object[])entry.getValue()) + ")").collect(Collectors.joining(", "));
    }
}

