/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.fs;

import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.ProducerOptionalBlobPartConfig;
import com.netflix.hollow.core.write.HollowBlobWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class HollowInMemoryBlobStager
implements HollowProducer.BlobStager {
    private final ProducerOptionalBlobPartConfig optionalPartConfig;

    public HollowInMemoryBlobStager() {
        this(null);
    }

    public HollowInMemoryBlobStager(ProducerOptionalBlobPartConfig optionalPartConfig) {
        this.optionalPartConfig = optionalPartConfig;
    }

    @Override
    public HollowProducer.Blob openSnapshot(long version) {
        return new InMemoryBlob(Long.MIN_VALUE, version, HollowProducer.Blob.Type.SNAPSHOT, this.optionalPartConfig);
    }

    @Override
    public HollowProducer.Blob openDelta(long fromVersion, long toVersion) {
        return new InMemoryBlob(fromVersion, toVersion, HollowProducer.Blob.Type.DELTA, this.optionalPartConfig);
    }

    @Override
    public HollowProducer.Blob openReverseDelta(long fromVersion, long toVersion) {
        return new InMemoryBlob(fromVersion, toVersion, HollowProducer.Blob.Type.REVERSE_DELTA, this.optionalPartConfig);
    }

    @Override
    public HollowProducer.HeaderBlob openHeader(long version) {
        return new InMemoryHeaderBlob(version);
    }

    public static class InMemoryBlob
    extends HollowProducer.Blob {
        private byte[] data;
        private Map<String, byte[]> optionalParts;

        protected InMemoryBlob(long fromVersion, long toVersion, HollowProducer.Blob.Type type) {
            super(fromVersion, toVersion, type);
        }

        protected InMemoryBlob(long fromVersion, long toVersion, HollowProducer.Blob.Type type, ProducerOptionalBlobPartConfig optionalPartConfig) {
            super(fromVersion, toVersion, type, optionalPartConfig);
        }

        @Override
        public void write(HollowBlobWriter writer) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ProducerOptionalBlobPartConfig.OptionalBlobPartOutputStreams optionalPartStreams = null;
            HashMap<String, ByteArrayOutputStream> optionalPartData = null;
            if (this.optionalPartConfig != null) {
                optionalPartStreams = this.optionalPartConfig.newStreams();
                optionalPartData = new HashMap<String, ByteArrayOutputStream>();
                for (String string : this.optionalPartConfig.getParts()) {
                    ByteArrayOutputStream partBaos = new ByteArrayOutputStream();
                    optionalPartStreams.addOutputStream(string, partBaos);
                    optionalPartData.put(string, partBaos);
                }
            }
            switch (this.type) {
                case SNAPSHOT: {
                    writer.writeSnapshot(baos, optionalPartStreams);
                    break;
                }
                case DELTA: {
                    writer.writeDelta(baos, optionalPartStreams);
                    break;
                }
                case REVERSE_DELTA: {
                    writer.writeReverseDelta(baos, optionalPartStreams);
                }
            }
            this.data = baos.toByteArray();
            if (this.optionalPartConfig != null) {
                this.optionalParts = new HashMap<String, byte[]>();
                for (Map.Entry entry : optionalPartData.entrySet()) {
                    this.optionalParts.put((String)entry.getKey(), ((ByteArrayOutputStream)entry.getValue()).toByteArray());
                }
            }
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        @Override
        public InputStream newOptionalPartInputStream(String partName) throws IOException {
            return new ByteArrayInputStream(this.optionalParts.get(partName));
        }

        @Override
        public Path getOptionalPartPath(String partName) {
            throw new UnsupportedOperationException("Path is not available");
        }

        @Override
        public void cleanup() {
        }
    }

    public static class InMemoryHeaderBlob
    extends HollowProducer.HeaderBlob {
        private byte[] data;

        protected InMemoryHeaderBlob(long version) {
            super(version);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void write(HollowBlobWriter blobWriter) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            blobWriter.writeHeader(baos, null);
            this.data = baos.toByteArray();
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }
    }
}

