/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.fs;

import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.ProducerOptionalBlobPartConfig;
import com.netflix.hollow.core.write.HollowBlobWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class HollowFilesystemBlobStager
implements HollowProducer.BlobStager {
    protected Path stagingPath;
    protected HollowProducer.BlobCompressor compressor;
    protected ProducerOptionalBlobPartConfig optionalPartConfig;

    public HollowFilesystemBlobStager() {
        this(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), HollowProducer.BlobCompressor.NO_COMPRESSION);
    }

    public HollowFilesystemBlobStager(Path stagingPath, HollowProducer.BlobCompressor compressor) throws RuntimeException {
        this(stagingPath, compressor, null);
    }

    public HollowFilesystemBlobStager(Path stagingPath, HollowProducer.BlobCompressor compressor, ProducerOptionalBlobPartConfig optionalPartConfig) throws RuntimeException {
        this.stagingPath = stagingPath;
        this.compressor = compressor;
        this.optionalPartConfig = optionalPartConfig;
        try {
            if (!Files.exists(stagingPath, new LinkOption[0])) {
                Files.createDirectories(stagingPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create folder; path=" + this.stagingPath, e);
        }
    }

    @Deprecated
    public HollowFilesystemBlobStager(File stagingPath, HollowProducer.BlobCompressor compressor) {
        this(stagingPath.toPath(), compressor);
    }

    @Override
    public HollowProducer.Blob openSnapshot(long version) {
        return new FilesystemBlob(Long.MIN_VALUE, version, HollowProducer.Blob.Type.SNAPSHOT, this.stagingPath, this.compressor, this.optionalPartConfig);
    }

    @Override
    public HollowProducer.Blob openDelta(long fromVersion, long toVersion) {
        return new FilesystemBlob(fromVersion, toVersion, HollowProducer.Blob.Type.DELTA, this.stagingPath, this.compressor, this.optionalPartConfig);
    }

    @Override
    public HollowProducer.Blob openReverseDelta(long fromVersion, long toVersion) {
        return new FilesystemBlob(fromVersion, toVersion, HollowProducer.Blob.Type.REVERSE_DELTA, this.stagingPath, this.compressor, this.optionalPartConfig);
    }

    @Override
    public HollowProducer.HeaderBlob openHeader(long version) {
        return new FilesystemHeaderBlob(version, this.stagingPath, this.compressor);
    }

    public static class FilesystemBlob
    extends HollowProducer.Blob {
        protected final Path path;
        protected final Map<String, Path> optionalPartPaths;
        private final HollowProducer.BlobCompressor compressor;

        private FilesystemBlob(long fromVersion, long toVersion, HollowProducer.Blob.Type type, Path dirPath, HollowProducer.BlobCompressor compressor, ProducerOptionalBlobPartConfig optionalPartConfig) {
            super(fromVersion, toVersion, type, optionalPartConfig);
            this.optionalPartPaths = optionalPartConfig == null ? Collections.emptyMap() : new HashMap();
            this.compressor = compressor;
            int randomExtension = new Random().nextInt() & Integer.MAX_VALUE;
            switch (type) {
                case SNAPSHOT: {
                    this.path = dirPath.resolve(String.format("%s-%d.%s", type.prefix, toVersion, Integer.toHexString(randomExtension)));
                    break;
                }
                case DELTA: 
                case REVERSE_DELTA: {
                    this.path = dirPath.resolve(String.format("%s-%d-%d.%s", type.prefix, fromVersion, toVersion, Integer.toHexString(randomExtension)));
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown blob type, type=" + (Object)((Object)type));
                }
            }
            if (optionalPartConfig != null) {
                for (String part : optionalPartConfig.getParts()) {
                    Path partPath;
                    switch (type) {
                        case SNAPSHOT: {
                            partPath = dirPath.resolve(String.format("%s_%s-%d.%s", type.prefix, part, toVersion, Integer.toHexString(randomExtension)));
                            break;
                        }
                        case DELTA: 
                        case REVERSE_DELTA: {
                            partPath = dirPath.resolve(String.format("%s_%s-%d-%d.%s", type.prefix, part, fromVersion, toVersion, Integer.toHexString(randomExtension)));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown blob type, type=" + (Object)((Object)type));
                        }
                    }
                    this.optionalPartPaths.put(part, partPath);
                }
            }
        }

        @Override
        public File getFile() {
            return this.path.toFile();
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void write(HollowBlobWriter writer) throws IOException {
            Path parent = this.path.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            if (!Files.exists(this.path, new LinkOption[0])) {
                Files.createFile(this.path, new FileAttribute[0]);
            }
            ProducerOptionalBlobPartConfig.OptionalBlobPartOutputStreams optionalPartStreams = null;
            if (this.optionalPartConfig != null) {
                optionalPartStreams = this.optionalPartConfig.newStreams();
                for (Map.Entry<String, Path> partPathEntry : this.optionalPartPaths.entrySet()) {
                    String partName = partPathEntry.getKey();
                    Path partPath = partPathEntry.getValue();
                    optionalPartStreams.addOutputStream(partName, new BufferedOutputStream(this.compressor.compress(Files.newOutputStream(partPath, new OpenOption[0]))));
                }
            }
            try (BufferedOutputStream os = new BufferedOutputStream(this.compressor.compress(Files.newOutputStream(this.path, new OpenOption[0])));){
                switch (this.type) {
                    case SNAPSHOT: {
                        writer.writeSnapshot(os, optionalPartStreams);
                        return;
                    }
                    case DELTA: {
                        writer.writeDelta(os, optionalPartStreams);
                        return;
                    }
                    case REVERSE_DELTA: {
                        writer.writeReverseDelta(os, optionalPartStreams);
                        return;
                    }
                    default: {
                        throw new IllegalStateException("unknown type, type=" + (Object)((Object)this.type));
                    }
                }
            }
            finally {
                if (optionalPartStreams != null) {
                    optionalPartStreams.close();
                }
            }
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return new BufferedInputStream(this.compressor.decompress(Files.newInputStream(this.path, new OpenOption[0])));
        }

        @Override
        public InputStream newOptionalPartInputStream(String partName) throws IOException {
            Path partPath = this.optionalPartPaths.get(partName);
            if (partPath == null) {
                throw new IllegalArgumentException("Path for part " + partName + " does not exist.");
            }
            return new BufferedInputStream(this.compressor.decompress(Files.newInputStream(partPath, new OpenOption[0])));
        }

        @Override
        public Path getOptionalPartPath(String partName) {
            Path partPath = this.optionalPartPaths.get(partName);
            if (partPath == null) {
                throw new IllegalArgumentException("Path for part " + partName + " does not exist.");
            }
            return partPath;
        }

        @Override
        public void cleanup() {
            this.cleanupFile(this.path);
            for (Map.Entry<String, Path> entry : this.optionalPartPaths.entrySet()) {
                this.cleanupFile(entry.getValue());
            }
        }

        private void cleanupFile(Path path) {
            try {
                if (path != null) {
                    Files.delete(path);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not cleanup file: " + this.path.toString(), e);
            }
        }
    }

    public static class FilesystemHeaderBlob
    extends HollowProducer.HeaderBlob {
        protected final Path path;
        private final HollowProducer.BlobCompressor compressor;

        protected FilesystemHeaderBlob(long version, Path dirPath, HollowProducer.BlobCompressor compressor) {
            super(version);
            this.compressor = compressor;
            int randomExtension = new Random().nextInt() & Integer.MAX_VALUE;
            this.path = dirPath.resolve(String.format("header-%d.%s", version, Integer.toHexString(randomExtension)));
        }

        @Override
        public void cleanup() {
            if (this.path != null) {
                try {
                    Files.delete(this.path);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not cleanup file: " + this.path, e);
                }
            }
        }

        @Override
        public void write(HollowBlobWriter blobWriter) throws IOException {
            Path parent = this.path.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            if (!Files.exists(this.path, new LinkOption[0])) {
                Files.createFile(this.path, new FileAttribute[0]);
            }
            try (BufferedOutputStream os = new BufferedOutputStream(this.compressor.compress(Files.newOutputStream(this.path, new OpenOption[0])));){
                blobWriter.writeHeader(os, null);
            }
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return new BufferedInputStream(this.compressor.decompress(Files.newInputStream(this.path, new OpenOption[0])));
        }

        @Override
        public File getFile() {
            return this.path.toFile();
        }

        @Override
        public Path getPath() {
            return this.path;
        }
    }
}

