/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ProducerOptionalBlobPartConfig {
    private final Map<String, Set<String>> parts = new HashMap<String, Set<String>>();

    public void addTypesToPart(String partName, String ... types) {
        if (types.length == 0) {
            return;
        }
        Set typeSet = this.parts.computeIfAbsent(partName, n -> new HashSet());
        for (String type : types) {
            typeSet.add(type);
        }
    }

    public Set<String> getParts() {
        return this.parts.keySet();
    }

    public OptionalBlobPartOutputStreams newStreams() {
        return new OptionalBlobPartOutputStreams();
    }

    public OptionalBlobPartOutputStreams newStreams(Function<String, OutputStream> streamCreator) {
        OptionalBlobPartOutputStreams s = this.newStreams();
        for (String part : this.getParts()) {
            s.addOutputStream(part, streamCreator.apply(part));
        }
        return s;
    }

    public static class ConfiguredOutputStream {
        private final String partName;
        private final Set<String> types;
        private final DataOutputStream stream;

        public ConfiguredOutputStream(String partName, Set<String> types, DataOutputStream stream) {
            this.partName = partName;
            this.types = Collections.unmodifiableSet(types);
            this.stream = stream;
        }

        public String getPartName() {
            return this.partName;
        }

        public Set<String> getTypes() {
            return this.types;
        }

        public DataOutputStream getStream() {
            return this.stream;
        }
    }

    public class OptionalBlobPartOutputStreams {
        private final Map<String, ConfiguredOutputStream> partStreams = new HashMap<String, ConfiguredOutputStream>();

        private OptionalBlobPartOutputStreams() {
        }

        public void addOutputStream(String partName, OutputStream os) {
            Set types = (Set)ProducerOptionalBlobPartConfig.this.parts.get(partName);
            if (types == null) {
                throw new IllegalArgumentException("There is no blob part named " + partName + " in this configuration");
            }
            this.partStreams.put(partName, new ConfiguredOutputStream(partName, types, new DataOutputStream(os)));
        }

        public Map<String, DataOutputStream> getStreamsByType() {
            if (!this.allPartsHaveStreams()) {
                throw new IllegalStateException("Not all configured parts have streams!");
            }
            HashMap<String, DataOutputStream> streamsByType = new HashMap<String, DataOutputStream>();
            for (Map.Entry<String, ConfiguredOutputStream> entry : this.partStreams.entrySet()) {
                ConfiguredOutputStream cos = entry.getValue();
                for (String type : cos.getTypes()) {
                    streamsByType.put(type, cos.getStream());
                }
            }
            return streamsByType;
        }

        public Map<String, String> getPartNameByType() {
            if (!this.allPartsHaveStreams()) {
                throw new IllegalStateException("Not all configured parts have streams!");
            }
            HashMap<String, String> streamsByType = new HashMap<String, String>();
            for (Map.Entry<String, ConfiguredOutputStream> entry : this.partStreams.entrySet()) {
                ConfiguredOutputStream cos = entry.getValue();
                for (String type : cos.getTypes()) {
                    streamsByType.put(type, cos.getPartName());
                }
            }
            return streamsByType;
        }

        public Map<String, ConfiguredOutputStream> getPartStreams() {
            return Collections.unmodifiableMap(this.partStreams);
        }

        public void flush() throws IOException {
            for (Map.Entry<String, ConfiguredOutputStream> entry : this.partStreams.entrySet()) {
                entry.getValue().getStream().flush();
            }
        }

        public void close() throws IOException {
            for (Map.Entry<String, ConfiguredOutputStream> entry : this.partStreams.entrySet()) {
                entry.getValue().getStream().close();
            }
        }

        private boolean allPartsHaveStreams() {
            return ProducerOptionalBlobPartConfig.this.parts.keySet().equals(this.partStreams.keySet());
        }
    }
}

