/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.perfapi;

public final class Ref {
    public static final int TYPE_ABSENT = -1;
    private static final long TYPE_MASK = 0xFFFF00000000L;
    public static final long NULL = -1L;

    private Ref() {
    }

    public static boolean isNonNull(long ref) {
        return ref != -1L;
    }

    public static boolean isNull(long ref) {
        return ref == -1L;
    }

    public static boolean isRefOfType(int type, long ref) {
        return Ref.isRefOfTypeMasked(Ref.toTypeMasked(type), ref);
    }

    public static boolean isRefOfTypeMasked(long typeMasked, long ref) {
        return Ref.typeMasked(ref) == typeMasked;
    }

    public static int ordinal(long ref) {
        return (int)ref;
    }

    public static int type(long ref) {
        return (int)(ref >>> 32);
    }

    public static long typeMasked(long ref) {
        return ref & 0xFFFF00000000L;
    }

    public static long toRef(int type, int ordinal) {
        return Ref.toTypeMasked(type) | (long)ordinal;
    }

    public static long toRefWithTypeMasked(long typeMasked, int ordinal) {
        return typeMasked | (long)ordinal;
    }

    public static long toTypeMasked(int type) {
        return (long)type << 32 & 0xFFFF00000000L;
    }
}

