/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.perfapi;

import com.netflix.hollow.api.perfapi.HashKeyExtractor;
import com.netflix.hollow.api.perfapi.HollowPerfBackedSet;
import com.netflix.hollow.api.perfapi.HollowPerfReferenceIterator;
import com.netflix.hollow.api.perfapi.HollowPerformanceAPI;
import com.netflix.hollow.api.perfapi.HollowTypePerfAPI;
import com.netflix.hollow.api.perfapi.POJOInstantiator;
import com.netflix.hollow.api.perfapi.Ref;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.missing.HollowSetMissingDataAccess;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import java.util.Set;

public class HollowSetTypePerfAPI
extends HollowTypePerfAPI {
    private final HollowSetTypeDataAccess typeAccess;
    final long elementMaskedTypeIdx;

    public HollowSetTypePerfAPI(HollowDataAccess dataAccess, String typeName, HollowPerformanceAPI api) {
        super(typeName, api);
        HollowSetTypeDataAccess typeAccess = (HollowSetTypeDataAccess)dataAccess.getTypeDataAccess(typeName);
        int elementTypeIdx = typeAccess == null ? -1 : api.types.getIdx(typeAccess.getSchema().getElementType());
        this.elementMaskedTypeIdx = Ref.toTypeMasked(elementTypeIdx);
        if (typeAccess == null) {
            typeAccess = new HollowSetMissingDataAccess(dataAccess, typeName);
        }
        this.typeAccess = typeAccess;
    }

    public int size(long ref) {
        return this.typeAccess.size(this.ordinal(ref));
    }

    public HollowPerfReferenceIterator iterator(long ref) {
        HollowOrdinalIterator iter = this.typeAccess.ordinalIterator(this.ordinal(ref));
        return new HollowPerfReferenceIterator(iter, this.elementMaskedTypeIdx);
    }

    public long findElement(long ref, Object ... hashKey) {
        int ordinal = this.typeAccess.findElement(this.ordinal(ref), hashKey);
        return Ref.toRefWithTypeMasked(this.elementMaskedTypeIdx, ordinal);
    }

    public <T> Set<T> backedSet(long ref, POJOInstantiator<T> instantiator, HashKeyExtractor hashKeyExtractor) {
        return new HollowPerfBackedSet<T>(this, ref, instantiator, hashKeyExtractor);
    }

    @Override
    public HollowSetTypeDataAccess typeAccess() {
        return this.typeAccess;
    }
}

