/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.perfapi;

import com.netflix.hollow.api.perfapi.HashKeyExtractor;
import com.netflix.hollow.api.perfapi.HollowMapTypePerfAPI;
import com.netflix.hollow.api.perfapi.POJOInstantiator;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class HollowPerfBackedMap<K, V>
extends AbstractMap<K, V> {
    private final int ordinal;
    private final HollowMapTypeDataAccess dataAccess;
    private final long keyMaskedTypeIdx;
    private final long valueMaskedTypeIdx;
    private final POJOInstantiator<K> keyInstantiator;
    private final POJOInstantiator<V> valueInstantiator;
    private final HashKeyExtractor hashKeyExtractor;

    public HollowPerfBackedMap(HollowMapTypePerfAPI typeApi, int ordinal, POJOInstantiator<K> keyInstantiator, POJOInstantiator<V> valueInstantiator, HashKeyExtractor hashKeyExtractor) {
        this.ordinal = ordinal;
        this.dataAccess = typeApi.typeAccess();
        this.keyMaskedTypeIdx = typeApi.keyMaskedTypeIdx;
        this.valueMaskedTypeIdx = typeApi.valueMaskedTypeIdx;
        this.keyInstantiator = keyInstantiator;
        this.valueInstantiator = valueInstantiator;
        this.hashKeyExtractor = hashKeyExtractor;
    }

    @Override
    public boolean containsKey(Object o) {
        Object[] hashKey = this.hashKeyExtractor.extractArray(o);
        return this.dataAccess.findValue(this.ordinal, hashKey) != -1;
    }

    @Override
    public V get(Object o) {
        Object[] hashKey = this.hashKeyExtractor.extractArray(o);
        int valueOrdinal = this.dataAccess.findValue(this.ordinal, hashKey);
        return valueOrdinal == -1 ? null : (V)this.valueInstantiator.instantiate(this.valueMaskedTypeIdx | (long)valueOrdinal);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final HollowMapEntryOrdinalIterator oi = HollowPerfBackedMap.this.dataAccess.ordinalIterator(HollowPerfBackedMap.this.ordinal);
                return new Iterator<Map.Entry<K, V>>(){
                    boolean next;
                    {
                        this.next = oi.next();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        long kRef = HollowPerfBackedMap.this.keyMaskedTypeIdx | (long)oi.getKey();
                        long vRef = HollowPerfBackedMap.this.valueMaskedTypeIdx | (long)oi.getValue();
                        BackedEntry e = new BackedEntry(kRef, vRef);
                        this.next = oi.next();
                        return e;
                    }
                };
            }

            @Override
            public int size() {
                return HollowPerfBackedMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                Object iV;
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object[] hashKey = HollowPerfBackedMap.this.hashKeyExtractor.extractArray(e.getKey());
                int valueOrdinal = HollowPerfBackedMap.this.dataAccess.findValue(HollowPerfBackedMap.this.ordinal, hashKey);
                return valueOrdinal != -1 && Objects.equals(iV = HollowPerfBackedMap.this.valueInstantiator.instantiate(HollowPerfBackedMap.this.valueMaskedTypeIdx | (long)valueOrdinal), e.getValue());
            }
        };
    }

    @Override
    public int size() {
        return this.dataAccess.size(this.ordinal);
    }

    final class BackedEntry
    implements Map.Entry<K, V> {
        final long kRef;
        final long vRef;
        boolean kInstantiated;
        K k;
        boolean vInstantiated;
        V v;

        BackedEntry(long kRef, long vRef) {
            this.kRef = kRef;
            this.vRef = vRef;
        }

        @Override
        public K getKey() {
            if (!this.kInstantiated) {
                this.kInstantiated = true;
                this.k = HollowPerfBackedMap.this.keyInstantiator.instantiate(this.kRef);
            }
            return this.k;
        }

        @Override
        public V getValue() {
            if (!this.vInstantiated) {
                this.vInstantiated = true;
                this.v = HollowPerfBackedMap.this.valueInstantiator.instantiate(this.vRef);
            }
            return this.v;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Objects.equals(this.getKey(), e.getKey()) && Objects.equals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            Object key = this.getKey();
            Object value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

