/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.consumer.index;

import com.netflix.hollow.api.consumer.index.FieldPath;
import com.netflix.hollow.api.objects.HollowObject;
import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.FieldPaths;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.write.objectmapper.HollowObjectTypeMapper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class MatchFieldPathArgumentExtractor<Q> {
    final FieldPaths.FieldPath<? extends FieldPaths.FieldSegment> fieldPath;
    final Function<Q, Object> extractor;

    MatchFieldPathArgumentExtractor(FieldPaths.FieldPath<? extends FieldPaths.FieldSegment> fieldPath, Function<Q, ?> extractor) {
        this.fieldPath = fieldPath;
        Function<Q, ?> erasedResultExtractor = extractor;
        this.extractor = erasedResultExtractor;
    }

    Object extract(Q v) {
        return this.extractor.apply(v);
    }

    static <Q> List<MatchFieldPathArgumentExtractor<Q>> fromHolderClass(HollowDataset dataset, Class<?> rootType, Class<Q> holder, FieldPathResolver fpResolver) {
        Stream<Field> fields = Stream.of(holder.getDeclaredFields()).filter(f -> f.isAnnotationPresent(FieldPath.class));
        Stream<Method> methods = Stream.of(holder.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(FieldPath.class)).filter(m -> m.getReturnType() != Void.TYPE).filter(m -> m.getParameterCount() == 0).filter(m -> !m.isSynthetic()).filter(m -> !Modifier.isNative(m.getModifiers()));
        return Stream.concat(fields, methods).sorted(Comparator.comparingInt(f -> f.getDeclaredAnnotation(FieldPath.class).order())).map(ae -> {
            try {
                if (ae instanceof Field) {
                    return MatchFieldPathArgumentExtractor.fromField(dataset, rootType, (Field)ae, fpResolver);
                }
                return MatchFieldPathArgumentExtractor.fromMethod(dataset, rootType, (Method)ae, fpResolver);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    static <Q> MatchFieldPathArgumentExtractor<Q> fromField(HollowDataset dataset, Class<?> rootType, Field f, FieldPathResolver fpResolver) throws IllegalAccessException {
        f.setAccessible(true);
        return MatchFieldPathArgumentExtractor.fromHandle(dataset, rootType, MatchFieldPathArgumentExtractor.getFieldPath(f), MethodHandles.lookup().unreflectGetter(f), fpResolver);
    }

    static <Q> MatchFieldPathArgumentExtractor<Q> fromMethod(HollowDataset dataset, Class<?> rootType, Method m, FieldPathResolver fpResolver) throws IllegalAccessException {
        if (m.getReturnType() == Void.TYPE || m.getParameterCount() > 0) {
            throw new IllegalArgumentException(String.format("A @FieldPath annotated method must have zero parameters and a non-void return type: %s", m.toGenericString()));
        }
        m.setAccessible(true);
        return MatchFieldPathArgumentExtractor.fromHandle(dataset, rootType, MatchFieldPathArgumentExtractor.getFieldPath(m), MethodHandles.lookup().unreflect(m), fpResolver);
    }

    static <Q> MatchFieldPathArgumentExtractor<Q> fromHandle(HollowDataset dataset, Class<?> rootType, String fieldPath, MethodHandle mh, FieldPathResolver fpResolver) {
        return MatchFieldPathArgumentExtractor.fromFunction(dataset, rootType, fieldPath, mh.type().returnType(), MatchFieldPathArgumentExtractor.getterGenericExtractor(mh), fpResolver);
    }

    static <T> MatchFieldPathArgumentExtractor<T> fromPathAndType(HollowDataset dataset, Class<?> rootType, String fieldPath, Class<T> type, FieldPathResolver fpResolver) {
        return MatchFieldPathArgumentExtractor.fromFunction(dataset, rootType, fieldPath, type, Function.identity(), fpResolver);
    }

    static IllegalArgumentException incompatibleMatchType(Class<?> extractorType, String fieldPath, HollowObjectSchema.FieldType schemaFieldType) {
        return new IllegalArgumentException(String.format("Match type %s incompatible with field path %s resolving to field of value type %s", new Object[]{extractorType.getName(), fieldPath, schemaFieldType}));
    }

    static IllegalArgumentException incompatibleMatchType(Class<?> extractorType, String fieldPath, String typeName) {
        return new IllegalArgumentException(String.format("Match type %s incompatible with field path %s resolving to field of reference type %s", extractorType.getName(), fieldPath, typeName));
    }

    static <Q, T> MatchFieldPathArgumentExtractor<Q> fromFunction(HollowDataset dataset, Class<?> rootType, String fieldPath, Class<T> extractorType, Function<Q, T> extractorFunction, FieldPathResolver fpResolver) {
        HollowObjectSchema.FieldType schemaFieldType;
        String rootTypeName = HollowObjectTypeMapper.getDefaultTypeName(rootType);
        FieldPaths.FieldPath<? extends FieldPaths.FieldSegment> fp = fpResolver.resolve(dataset, rootTypeName, fieldPath);
        FieldPaths.FieldSegment lastSegment = fp.getSegments().get(fp.getSegments().size() - 1);
        if (lastSegment.getEnclosingSchema().getSchemaType() == HollowSchema.SchemaType.OBJECT) {
            FieldPaths.ObjectFieldSegment os = (FieldPaths.ObjectFieldSegment)lastSegment;
            schemaFieldType = os.getType();
        } else {
            schemaFieldType = HollowObjectSchema.FieldType.REFERENCE;
        }
        Function<Q, Object> extractor = extractorFunction;
        switch (schemaFieldType) {
            case BOOLEAN: {
                if (extractorType == Boolean.TYPE || extractorType == Boolean.class) break;
                throw MatchFieldPathArgumentExtractor.incompatibleMatchType(extractorType, fieldPath, schemaFieldType);
            }
            case DOUBLE: {
                if (extractorType == Double.TYPE || extractorType == Double.class) break;
                throw MatchFieldPathArgumentExtractor.incompatibleMatchType(extractorType, fieldPath, schemaFieldType);
            }
            case FLOAT: {
                if (extractorType == Float.TYPE || extractorType == Float.class) break;
                throw MatchFieldPathArgumentExtractor.incompatibleMatchType(extractorType, fieldPath, schemaFieldType);
            }
            case INT: {
                if (extractorType == Byte.TYPE || extractorType == Byte.class) {
                    Function<Q, T> f = extractorFunction;
                    extractor = f.andThen(Byte::intValue);
                    break;
                }
                if (extractorType == Short.TYPE || extractorType == Short.class) {
                    Function<Q, T> f = extractorFunction;
                    extractor = f.andThen(Short::intValue);
                    break;
                }
                if (extractorType == Character.TYPE || extractorType == Character.class) {
                    Function<Q, T> f = extractorFunction;
                    extractor = f.andThen(c -> c.charValue());
                    break;
                }
                if (extractorType == Integer.TYPE || extractorType == Integer.class) break;
                throw MatchFieldPathArgumentExtractor.incompatibleMatchType(extractorType, fieldPath, schemaFieldType);
            }
            case LONG: {
                if (extractorType == Long.TYPE || extractorType == Long.class) break;
                throw MatchFieldPathArgumentExtractor.incompatibleMatchType(extractorType, fieldPath, schemaFieldType);
            }
            case REFERENCE: {
                String typeName = lastSegment.getTypeName();
                if (typeName.equals("String")) {
                    if (!HollowObject.class.isAssignableFrom(extractorType)) {
                        throw MatchFieldPathArgumentExtractor.incompatibleMatchType(extractorType, fieldPath, typeName);
                    }
                } else {
                    if (!extractorType.getSimpleName().equals(typeName)) {
                        throw MatchFieldPathArgumentExtractor.incompatibleMatchType(extractorType, fieldPath, typeName);
                    }
                    if (!HollowRecord.class.isAssignableFrom(extractorType)) {
                        throw MatchFieldPathArgumentExtractor.incompatibleMatchType(extractorType, fieldPath, typeName);
                    }
                }
                Function<Q, T> f = extractorFunction;
                extractor = f.andThen(HollowRecord::getOrdinal);
                break;
            }
            case BYTES: {
                if (extractorType == byte[].class) break;
                throw MatchFieldPathArgumentExtractor.incompatibleMatchType(extractorType, fieldPath, schemaFieldType);
            }
            case STRING: {
                if (extractorType == char[].class) {
                    Function<Q, T> f = extractorFunction;
                    extractor = f.andThen(String::valueOf);
                    break;
                }
                if (extractorType == String.class) break;
                throw MatchFieldPathArgumentExtractor.incompatibleMatchType(extractorType, fieldPath, schemaFieldType);
            }
        }
        return new MatchFieldPathArgumentExtractor<Q>(fp, extractor);
    }

    private static <Q, T> Function<Q, T> getterGenericExtractor(MethodHandle getter) {
        return h -> {
            try {
                Object t = getter.invoke(h);
                return t;
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static String getFieldPath(Field f) {
        return MatchFieldPathArgumentExtractor.getFieldPath(f, f);
    }

    private static String getFieldPath(Method m) {
        return MatchFieldPathArgumentExtractor.getFieldPath(m, m);
    }

    private static String getFieldPath(Member m, AnnotatedElement e) {
        FieldPath fpa = e.getDeclaredAnnotation(FieldPath.class);
        if (fpa == null) {
            return m.getName();
        }
        String fieldPath = e.getDeclaredAnnotation(FieldPath.class).value();
        if (fieldPath.isEmpty()) {
            return m.getName();
        }
        return fieldPath;
    }

    static interface FieldPathResolver {
        public FieldPaths.FieldPath<? extends FieldPaths.FieldSegment> resolve(HollowDataset var1, String var2, String var3);
    }
}

