/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.perfapi;

import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.Set;

class HollowObjectTypePerfAPIClassGenerator {
    private final HollowObjectSchema schema;
    private final String packageName;
    private final Set<String> checkFieldExistsMethods;

    public HollowObjectTypePerfAPIClassGenerator(HollowObjectSchema schema, String packageName, Set<String> checkFieldExistsMethods) {
        this.schema = schema;
        this.packageName = packageName;
        this.checkFieldExistsMethods = checkFieldExistsMethods;
    }

    public String generate() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("package " + this.packageName + ";\n\n");
        builder.append("import com.netflix.hollow.api.perfapi.HollowObjectTypePerfAPI;\nimport com.netflix.hollow.api.perfapi.HollowPerformanceAPI;\nimport com.netflix.hollow.api.perfapi.Ref;\nimport com.netflix.hollow.core.read.dataaccess.HollowDataAccess;\n\n");
        builder.append("\n@SuppressWarnings(\"all\")\n");
        builder.append("public class " + this.schema.getName() + "PerfAPI extends HollowObjectTypePerfAPI {\n\n");
        builder.append("    public static final String fieldNames[] = { ");
        for (i = 0; i < this.schema.numFields(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append("\"" + this.schema.getFieldName(i) + "\"");
        }
        builder.append(" };\n\n");
        builder.append("    public " + this.schema.getName() + "PerfAPI(HollowDataAccess dataAccess, String typeName, HollowPerformanceAPI api) {\n");
        builder.append("        super(dataAccess, typeName, api, fieldNames);\n");
        builder.append("    }\n\n");
        for (i = 0; i < this.schema.numFields(); ++i) {
            HollowObjectSchema.FieldType fieldType = this.schema.getFieldType(i);
            String fieldName = this.schema.getFieldName(i);
            String referencedType = this.schema.getReferencedType(i);
            this.appendFieldMethod(builder, fieldType, fieldName, i, referencedType);
        }
        builder.append("}");
        return builder.toString();
    }

    public void appendFieldMethod(StringBuilder builder, HollowObjectSchema.FieldType fieldType, String fieldName, int fieldIdx, String referencedType) {
        String type = fieldType.name();
        if (fieldType == HollowObjectSchema.FieldType.REFERENCE) {
            type = type + " (" + referencedType + ")";
        }
        builder.append("    /**\n     * <i>" + this.schema.getName() + "." + fieldName + "</i><br/>\n     * <b>" + type + "</b>\n     */\n");
        switch (fieldType) {
            case INT: {
                builder.append("    public int get" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "(long ref) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return Integer.MIN_VALUE;\n");
                builder.append("        return typeAccess.readInt(ordinal(ref), fieldIdx[" + fieldIdx + "]);\n");
                builder.append("    }\n\n");
                builder.append("    public Integer get" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "Boxed(long ref) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return null;\n");
                builder.append("        int val = typeAccess.readInt(ordinal(ref), fieldIdx[" + fieldIdx + "]);\n");
                builder.append("        if(val == Integer.MIN_VALUE)\n");
                builder.append("            return null;\n");
                builder.append("        return val;\n");
                builder.append("    }\n\n");
                break;
            }
            case LONG: {
                builder.append("    public long get" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "(long ref) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return Long.MIN_VALUE;\n");
                builder.append("        return typeAccess.readLong(ordinal(ref), fieldIdx[" + fieldIdx + "]);\n");
                builder.append("    }\n\n");
                builder.append("    public Long get" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "Boxed(long ref) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return null;\n");
                builder.append("        long val = typeAccess.readLong(ordinal(ref), fieldIdx[" + fieldIdx + "]);\n");
                builder.append("        if(val == Long.MIN_VALUE)\n");
                builder.append("            return null;\n");
                builder.append("        return val;\n");
                builder.append("    }\n\n");
                break;
            }
            case FLOAT: {
                builder.append("    public float get" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "(long ref) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return Float.NaN;\n");
                builder.append("        return typeAccess.readFloat(ordinal(ref), fieldIdx[" + fieldIdx + "]);\n");
                builder.append("    }\n\n");
                builder.append("    public Float get" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "Boxed(long ref) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return null;\n");
                builder.append("        float val = typeAccess.readFloat(ordinal(ref), fieldIdx[" + fieldIdx + "]);\n");
                builder.append("        if(Float.isNaN(val))\n");
                builder.append("            return null;\n");
                builder.append("        return val;\n");
                builder.append("    }\n\n");
                break;
            }
            case DOUBLE: {
                builder.append("    public double get" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "(long ref) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return Double.NaN;\n");
                builder.append("        return typeAccess.readDouble(ordinal(ref), fieldIdx[" + fieldIdx + "]);\n");
                builder.append("    }\n\n");
                builder.append("    public Double get" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "Boxed(long ref) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return null;\n");
                builder.append("        double val = typeAccess.readDouble(ordinal(ref), fieldIdx[" + fieldIdx + "]);\n");
                builder.append("        if(Double.isNaN(val))\n");
                builder.append("            return null;\n");
                builder.append("        return val;\n");
                builder.append("    }\n\n");
                break;
            }
            case BOOLEAN: {
                builder.append("    public boolean get" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "(long ref) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return false;\n");
                builder.append("        return Boolean.TRUE.equals(typeAccess.readBoolean(ordinal(ref), fieldIdx[" + fieldIdx + "]));\n");
                builder.append("    }\n\n");
                builder.append("    public Boolean get" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "Boxed(long ref) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return null;\n");
                builder.append("        return typeAccess.readBoolean(ordinal(ref), fieldIdx[" + fieldIdx + "]);\n");
                builder.append("    }\n\n");
                break;
            }
            case STRING: {
                builder.append("    public String get" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "(long ref) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return null;\n");
                builder.append("        return typeAccess.readString(ordinal(ref), fieldIdx[" + fieldIdx + "]);\n");
                builder.append("    }\n\n");
                builder.append("    public boolean is" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "Equal(long ref, String testValue) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return false;\n");
                builder.append("        return typeAccess.isStringFieldEqual(ordinal(ref), fieldIdx[" + fieldIdx + "], testValue);\n");
                builder.append("    }\n\n");
                break;
            }
            case BYTES: {
                builder.append("    public byte[] get" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "(long ref) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return null;\n");
                builder.append("        return typeAccess.readBytes(ordinal(ref), fieldIdx[" + fieldIdx + "]);\n");
                builder.append("    }\n\n");
                break;
            }
            case REFERENCE: {
                builder.append("    public long get" + HollowCodeGenerationUtils.upperFirstChar(fieldName) + "Ref(long ref) {\n");
                builder.append("        if(fieldIdx[" + fieldIdx + "] == -1)\n");
                builder.append("            return Ref.NULL;\n");
                builder.append("        return Ref.toRefWithTypeMasked(refMaskedTypeIdx[" + fieldIdx + "], typeAccess.readOrdinal(ordinal(ref), fieldIdx[" + fieldIdx + "]));\n");
                builder.append("    }\n\n");
            }
        }
        if (this.checkFieldExistsMethods.contains(this.schema.getName() + "." + fieldName)) {
            builder.append("    public boolean " + fieldName + "FieldExists() {\n");
            builder.append("        return fieldIdx[" + fieldIdx + "] != -1;\n");
            builder.append("    }\n\n");
        }
    }
}

