/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.client;

import com.netflix.hollow.api.client.FailedTransitionTracker;
import com.netflix.hollow.api.client.HollowAPIFactory;
import com.netflix.hollow.api.client.HollowUpdatePlan;
import com.netflix.hollow.api.client.StaleHollowReferenceDetector;
import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.OptionalBlobPartInput;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.proxy.HollowProxyDataAccess;
import com.netflix.hollow.core.read.engine.HollowBlobReader;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.filter.TypeFilter;
import com.netflix.hollow.tools.history.HollowHistoricalStateCreator;
import com.netflix.hollow.tools.history.HollowHistoricalStateDataAccess;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;

class HollowDataHolder {
    private static final Logger LOG = Logger.getLogger(HollowDataHolder.class.getName());
    private final HollowReadStateEngine stateEngine;
    private final HollowAPIFactory apiFactory;
    private final MemoryMode memoryMode;
    private final HollowBlobReader reader;
    private final HollowConsumer.DoubleSnapshotConfig doubleSnapshotConfig;
    private final FailedTransitionTracker failedTransitionTracker;
    private final StaleHollowReferenceDetector staleReferenceDetector;
    private final HollowConsumer.ObjectLongevityConfig objLongevityConfig;
    private TypeFilter filter;
    private HollowAPI currentAPI;
    private WeakReference<HollowHistoricalStateDataAccess> priorHistoricalDataAccess;
    private long currentVersion = Long.MIN_VALUE;

    HollowDataHolder(HollowReadStateEngine stateEngine, HollowAPIFactory apiFactory, MemoryMode memoryMode, HollowConsumer.DoubleSnapshotConfig doubleSnapshotConfig, FailedTransitionTracker failedTransitionTracker, StaleHollowReferenceDetector staleReferenceDetector, HollowConsumer.ObjectLongevityConfig objLongevityConfig) {
        this.stateEngine = stateEngine;
        this.apiFactory = apiFactory;
        this.memoryMode = memoryMode;
        this.reader = new HollowBlobReader(stateEngine, memoryMode);
        this.doubleSnapshotConfig = doubleSnapshotConfig;
        this.failedTransitionTracker = failedTransitionTracker;
        this.staleReferenceDetector = staleReferenceDetector;
        this.objLongevityConfig = objLongevityConfig;
    }

    HollowReadStateEngine getStateEngine() {
        return this.stateEngine;
    }

    HollowAPI getAPI() {
        return this.currentAPI;
    }

    long getCurrentVersion() {
        return this.currentVersion;
    }

    HollowDataHolder setFilter(HollowFilterConfig filter) {
        return this.setFilter((TypeFilter)filter);
    }

    HollowDataHolder setFilter(TypeFilter filter) {
        this.filter = filter;
        return this;
    }

    HollowDataHolder setSkipTypeShardUpdateWithNoAdditions(boolean skipTypeShardUpdateWithNoAdditions) {
        this.stateEngine.setSkipTypeShardUpdateWithNoAdditions(skipTypeShardUpdateWithNoAdditions);
        return this;
    }

    void update(HollowUpdatePlan updatePlan, HollowConsumer.RefreshListener[] refreshListeners, Runnable apiInitCallback) throws Throwable {
        if (this.doubleSnapshotConfig.allowDoubleSnapshot() && this.failedTransitionTracker.anyTransitionWasFailed(updatePlan)) {
            throw new RuntimeException("Update plan contains known failing transition!");
        }
        if (updatePlan.isSnapshotPlan()) {
            this.applySnapshotPlan(updatePlan, refreshListeners, apiInitCallback);
        } else {
            this.applyDeltaOnlyPlan(updatePlan, refreshListeners);
        }
    }

    private void applySnapshotPlan(HollowUpdatePlan updatePlan, HollowConsumer.RefreshListener[] refreshListeners, Runnable apiInitCallback) throws Throwable {
        this.applySnapshotTransition(updatePlan.getSnapshotTransition(), refreshListeners, apiInitCallback);
        for (HollowConsumer.Blob blob : updatePlan.getDeltaTransitions()) {
            this.applyDeltaTransition(blob, true, refreshListeners);
        }
        try {
            for (HollowConsumer.RefreshListener refreshListener : refreshListeners) {
                refreshListener.snapshotUpdateOccurred(this.currentAPI, this.stateEngine, updatePlan.destinationVersion());
            }
        }
        catch (Throwable t) {
            this.failedTransitionTracker.markAllTransitionsAsFailed(updatePlan);
            throw t;
        }
    }

    private void applySnapshotTransition(HollowConsumer.Blob snapshotBlob, HollowConsumer.RefreshListener[] refreshListeners, Runnable apiInitCallback) throws Throwable {
        try (HollowBlobInput in = HollowBlobInput.modeBasedSelector(this.memoryMode, snapshotBlob);
             OptionalBlobPartInput optionalPartIn = snapshotBlob.getOptionalBlobPartInputs();){
            this.applyStateEngineTransition(in, optionalPartIn, snapshotBlob, refreshListeners);
            this.initializeAPI(apiInitCallback);
            for (HollowConsumer.RefreshListener refreshListener : refreshListeners) {
                if (!(refreshListener instanceof HollowConsumer.TransitionAwareRefreshListener)) continue;
                ((HollowConsumer.TransitionAwareRefreshListener)refreshListener).snapshotApplied(this.currentAPI, this.stateEngine, snapshotBlob.getToVersion());
            }
        }
        catch (Throwable t) {
            this.failedTransitionTracker.markFailedTransition(snapshotBlob);
            throw t;
        }
    }

    private void applyStateEngineTransition(HollowBlobInput in, OptionalBlobPartInput optionalPartIn, HollowConsumer.Blob transition, HollowConsumer.RefreshListener[] refreshListeners) throws IOException {
        if (transition.isSnapshot()) {
            if (this.filter == null) {
                this.reader.readSnapshot(in, optionalPartIn);
            } else {
                this.reader.readSnapshot(in, optionalPartIn, this.filter);
            }
        } else {
            this.reader.applyDelta(in, optionalPartIn);
        }
        this.setVersion(transition.getToVersion());
        for (HollowConsumer.RefreshListener refreshListener : refreshListeners) {
            refreshListener.blobLoaded(transition);
        }
    }

    private void initializeAPI(Runnable r) {
        if (this.objLongevityConfig.enableLongLivedObjectSupport()) {
            HollowProxyDataAccess dataAccess = new HollowProxyDataAccess();
            dataAccess.setDataAccess(this.stateEngine);
            this.currentAPI = this.apiFactory.createAPI(dataAccess);
        } else {
            this.currentAPI = this.apiFactory.createAPI(this.stateEngine);
        }
        this.staleReferenceDetector.newAPIHandle(this.currentAPI);
        try {
            r.run();
        }
        catch (Throwable t) {
            LOG.warning("Failed to execute API init callback: " + t);
        }
    }

    private void applyDeltaOnlyPlan(HollowUpdatePlan updatePlan, HollowConsumer.RefreshListener[] refreshListeners) throws Throwable {
        for (HollowConsumer.Blob blob : updatePlan) {
            this.applyDeltaTransition(blob, false, refreshListeners);
        }
    }

    private void applyDeltaTransition(HollowConsumer.Blob blob, boolean isSnapshotPlan, HollowConsumer.RefreshListener[] refreshListeners) throws Throwable {
        if (!this.memoryMode.equals((Object)MemoryMode.ON_HEAP)) {
            LOG.warning("Skipping delta transition in shared-memory mode");
            return;
        }
        try (HollowBlobInput in = HollowBlobInput.modeBasedSelector(this.memoryMode, blob);
             OptionalBlobPartInput optionalPartIn = blob.getOptionalBlobPartInputs();){
            this.applyStateEngineTransition(in, optionalPartIn, blob, refreshListeners);
            if (this.objLongevityConfig.enableLongLivedObjectSupport()) {
                HollowDataAccess previousDataAccess = this.currentAPI.getDataAccess();
                HollowHistoricalStateDataAccess priorState = new HollowHistoricalStateCreator(null).createBasedOnNewDelta(this.currentVersion, this.stateEngine);
                HollowProxyDataAccess newDataAccess = new HollowProxyDataAccess();
                newDataAccess.setDataAccess(this.stateEngine);
                this.currentAPI = this.apiFactory.createAPI(newDataAccess, this.currentAPI);
                if (previousDataAccess instanceof HollowProxyDataAccess) {
                    ((HollowProxyDataAccess)previousDataAccess).setDataAccess(priorState);
                }
                this.wireHistoricalStateChain(priorState);
            } else {
                if (this.currentAPI.getDataAccess() != this.stateEngine) {
                    this.currentAPI = this.apiFactory.createAPI(this.stateEngine);
                }
                this.priorHistoricalDataAccess = null;
            }
            if (!this.staleReferenceDetector.isKnownAPIHandle(this.currentAPI)) {
                this.staleReferenceDetector.newAPIHandle(this.currentAPI);
            }
            for (HollowConsumer.RefreshListener refreshListener : refreshListeners) {
                if (!isSnapshotPlan) {
                    refreshListener.deltaUpdateOccurred(this.currentAPI, this.stateEngine, blob.getToVersion());
                }
                if (!(refreshListener instanceof HollowConsumer.TransitionAwareRefreshListener)) continue;
                ((HollowConsumer.TransitionAwareRefreshListener)refreshListener).deltaApplied(this.currentAPI, this.stateEngine, blob.getToVersion());
            }
        }
        catch (Throwable t) {
            this.failedTransitionTracker.markFailedTransition(blob);
            throw t;
        }
    }

    private void wireHistoricalStateChain(HollowHistoricalStateDataAccess nextPriorState) {
        HollowHistoricalStateDataAccess dataAccess;
        if (this.priorHistoricalDataAccess != null && (dataAccess = (HollowHistoricalStateDataAccess)this.priorHistoricalDataAccess.get()) != null) {
            dataAccess.setNextState(nextPriorState);
        }
        this.priorHistoricalDataAccess = new WeakReference<HollowHistoricalStateDataAccess>(nextPriorState);
    }

    private void setVersion(long version) {
        this.currentVersion = version;
    }
}

