/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import lombok.NonNull;

public final class PathUtils {
    public static void recursiveDeleteDir(@NonNull Path directory) {
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void mkdirp(Path directory) {
        boolean result = directory.toFile().mkdirs();
        if (!result) {
            throw new IllegalStateException("Failed to create directory at: " + directory);
        }
    }

    public static String createMinGWPath(String path) {
        String mingwPath = path.replace('\\', '/');
        int driveLetterIndex = 1;
        if (mingwPath.matches("^[a-zA-Z]:\\/.*")) {
            driveLetterIndex = 0;
        }
        mingwPath = "//" + Character.toLowerCase(mingwPath.charAt(driveLetterIndex)) + mingwPath.substring(driveLetterIndex + 1);
        mingwPath = mingwPath.replace(":", "");
        return mingwPath;
    }

    private PathUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

