/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.images.ImageData;
import org.testcontainers.images.ImagePullPolicy;
import org.testcontainers.images.LocalImagesCache;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.DockerLoggerFactory;

public abstract class AbstractImagePullPolicy
implements ImagePullPolicy {
    private static final Logger log = LoggerFactory.getLogger(AbstractImagePullPolicy.class);
    private static final LocalImagesCache LOCAL_IMAGES_CACHE = LocalImagesCache.INSTANCE;

    @Override
    public boolean shouldPull(DockerImageName imageName) {
        Logger logger = DockerLoggerFactory.getLogger(imageName.asCanonicalNameString());
        ImageData cachedImageData = LOCAL_IMAGES_CACHE.get(imageName);
        if (cachedImageData != null) {
            logger.trace("{} is already in image name cache", (Object)imageName);
        } else {
            logger.debug("{} is not in image name cache, updating...", (Object)imageName);
            cachedImageData = LOCAL_IMAGES_CACHE.refreshCache(imageName).orElse(null);
            if (cachedImageData == null) {
                log.debug("Not available locally, should pull image: {}", (Object)imageName);
                return true;
            }
        }
        if (this.shouldPullCached(imageName, cachedImageData)) {
            log.debug("Should pull locally available image: {}", (Object)imageName);
            return true;
        }
        log.debug("Using locally available and not pulling image: {}", (Object)imageName);
        return false;
    }

    protected abstract boolean shouldPullCached(DockerImageName var1, ImageData var2);
}

