/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolFeatures;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import java.util.Map;

public class Startup
extends Message {
    public static final String CQL_VERSION_KEY = "CQL_VERSION";
    public static final String COMPRESSION_KEY = "COMPRESSION";
    private static final String CQL_VERSION = "3.0.0";
    public final Map<String, String> options;

    public Startup(String compressionAlgorithm) {
        this(compressionAlgorithm == null || compressionAlgorithm.isEmpty() ? NullAllowingImmutableMap.of(CQL_VERSION_KEY, CQL_VERSION) : NullAllowingImmutableMap.of(CQL_VERSION_KEY, CQL_VERSION, COMPRESSION_KEY, compressionAlgorithm));
    }

    public Startup() {
        this((Map<String, String>)null);
    }

    public Startup(Map<String, String> options) {
        super(false, 1);
        if (options != null) {
            if (options.containsKey(CQL_VERSION_KEY)) {
                this.options = NullAllowingImmutableMap.copyOf(options);
            } else {
                NullAllowingImmutableMap.Builder<String, String> builder = NullAllowingImmutableMap.builder(options.size() + 1);
                this.options = builder.put(CQL_VERSION_KEY, CQL_VERSION).putAll(options).build();
            }
        } else {
            this.options = NullAllowingImmutableMap.of(CQL_VERSION_KEY, CQL_VERSION);
        }
    }

    public String toString() {
        return "STARTUP " + this.options;
    }

    public static class Codec
    extends Message.Codec {
        public Codec(int protocolVersion) {
            super(1, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder, ProtocolFeatures protocolFeatures) {
            Startup startup = (Startup)message;
            encoder.writeStringMap(startup.options, dest);
        }

        @Override
        public int encodedSize(Message message, ProtocolFeatures protocolFeatures) {
            Startup startup = (Startup)message;
            return PrimitiveSizes.sizeOfStringMap(startup.options);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder, ProtocolFeatures protocolFeatures) {
            Map<String, String> map = decoder.readStringMap(source);
            return new Startup(map);
        }
    }
}

