/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal;

import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.FrameCodec;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.ProtocolFeatures;
import com.datastax.oss.protocol.internal.Segment;
import java.util.ArrayList;
import java.util.List;

public abstract class SegmentBuilder<B, StateT> {
    private final PrimitiveCodec<B> primitiveCodec;
    private final FrameCodec<B> frameCodec;
    private final int maxPayloadLength;
    private final List<Frame> currentPayloadFrames = new ArrayList<Frame>();
    private final List<StateT> currentPayloadStates = new ArrayList<StateT>();
    private int currentPayloadLength;

    protected SegmentBuilder(PrimitiveCodec<B> primitiveCodec, FrameCodec<B> frameCodec) {
        this(primitiveCodec, frameCodec, Segment.MAX_PAYLOAD_LENGTH);
    }

    SegmentBuilder(PrimitiveCodec<B> primitiveCodec, FrameCodec<B> frameCodec, int maxPayloadLength) {
        this.primitiveCodec = primitiveCodec;
        this.frameCodec = frameCodec;
        this.maxPayloadLength = maxPayloadLength;
    }

    protected abstract StateT mergeStates(List<StateT> var1);

    protected abstract List<StateT> splitState(StateT var1, int var2);

    protected abstract void processSegment(Segment<B> var1, StateT var2);

    public void addFrame(Frame frame, StateT frameState) {
        int frameBodyLength = this.frameCodec.encodedBodySize(frame, ProtocolFeatures.EMPTY);
        int frameLength = this.frameCodec.encodedHeaderSize(frame) + frameBodyLength;
        if (frameLength > this.maxPayloadLength) {
            B frameBuffer = this.primitiveCodec.allocate(frameLength);
            this.frameCodec.encodeInto(frame, frameBodyLength, frameBuffer, ProtocolFeatures.EMPTY);
            boolean isExactMultiple = frameLength % this.maxPayloadLength == 0;
            int sliceCount = frameLength / this.maxPayloadLength + (isExactMultiple ? 0 : 1);
            this.onLargeFrameSplit(frame, frameLength, sliceCount);
            List<StateT> sliceStates = this.splitState(frameState, sliceCount);
            for (int i = 0; i < sliceCount; ++i) {
                int sliceLength = i < sliceCount - 1 || isExactMultiple ? this.maxPayloadLength : frameLength % this.maxPayloadLength;
                B slicePayload = this.primitiveCodec.readRetainedSlice(frameBuffer, sliceLength);
                this.processSegment(new Segment<B>(slicePayload, false), sliceStates.get(i));
            }
            this.primitiveCodec.release(frameBuffer);
        } else {
            if (this.currentPayloadLength + frameLength > this.maxPayloadLength) {
                this.onSegmentFull(frame, frameLength, this.currentPayloadLength, this.currentPayloadFrames.size());
                this.processCurrentPayload();
                this.resetCurrentPayload();
            }
            this.currentPayloadFrames.add(frame);
            this.currentPayloadStates.add(frameState);
            this.currentPayloadLength += frameLength;
            this.onSmallFrameAdded(frame, frameLength, this.currentPayloadLength, this.currentPayloadFrames.size());
        }
    }

    public void flush() {
        if (!this.currentPayloadFrames.isEmpty()) {
            this.onLastSegmentFlushed(this.currentPayloadLength, this.currentPayloadFrames.size());
            this.processCurrentPayload();
            this.resetCurrentPayload();
        }
    }

    protected void onLargeFrameSplit(Frame frame, int frameLength, int sliceCount) {
    }

    protected void onSegmentFull(Frame frame, int frameLength, int currentPayloadLength, int currentFrameCount) {
    }

    protected void onSmallFrameAdded(Frame frame, int frameLength, int currentPayloadLength, int currentFrameCount) {
    }

    protected void onLastSegmentFlushed(int currentPayloadLength, int currentFrameCount) {
    }

    private void processCurrentPayload() {
        assert (this.currentPayloadLength <= this.maxPayloadLength);
        B payload = this.primitiveCodec.allocate(this.currentPayloadLength);
        for (Frame frame : this.currentPayloadFrames) {
            this.frameCodec.encodeInto(frame, -1, payload, ProtocolFeatures.EMPTY);
        }
        assert (this.primitiveCodec.sizeOf(payload) == this.currentPayloadLength);
        StateT state = this.mergeStates(this.currentPayloadStates);
        this.processSegment(new Segment<B>(payload, true), state);
    }

    private void resetCurrentPayload() {
        this.currentPayloadFrames.clear();
        this.currentPayloadStates.clear();
        this.currentPayloadLength = 0;
    }
}

