/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class UuidCodec
implements TypeCodec<UUID> {
    @Override
    @NonNull
    public GenericType<UUID> getJavaType() {
        return GenericType.UUID;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.UUID;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof UUID;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == UUID.class;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable UUID value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        ByteBuffer bytes = ByteBuffer.allocate(16);
        bytes.putLong(0, value.getMostSignificantBits());
        bytes.putLong(8, value.getLeastSignificantBits());
        return bytes;
    }

    @Override
    @Nullable
    public UUID decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        if (bytes.remaining() != 16) {
            throw new IllegalArgumentException("Unexpected number of bytes for a UUID, expected 16, got " + bytes.remaining());
        }
        return new UUID(bytes.getLong(bytes.position()), bytes.getLong(bytes.position() + 8));
    }

    @Override
    @NonNull
    public String format(@Nullable UUID value) {
        return value == null ? "NULL" : value.toString();
    }

    @Override
    @Nullable
    public UUID parse(@Nullable String value) {
        try {
            return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : UUID.fromString(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Cannot parse UUID value from \"%s\"", value), e);
        }
    }

    @Override
    @NonNull
    public Optional<Integer> serializedSize() {
        return Optional.of(16);
    }
}

