/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.token.Partitioner;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.token.KeyspaceTokenMap;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategyFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.internal.core.util.RoutingKey;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSetMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.SetMultimap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class DefaultTokenMap
implements TokenMap {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTokenMap.class);
    private final TokenFactory tokenFactory;
    @VisibleForTesting
    final Set<TokenRange> tokenRanges;
    @VisibleForTesting
    final SetMultimap<Node, TokenRange> tokenRangesByPrimary;
    @VisibleForTesting
    final Map<CqlIdentifier, Map<String, String>> replicationConfigs;
    @VisibleForTesting
    final Map<Map<String, String>, KeyspaceTokenMap> keyspaceMaps;
    private final String logPrefix;

    public static DefaultTokenMap build(@NonNull Collection<Node> nodes, @NonNull Collection<KeyspaceMetadata> keyspaces, @NonNull TokenFactory tokenFactory, @NonNull ReplicationStrategyFactory replicationStrategyFactory, @NonNull String logPrefix) {
        TokenToPrimaryAndRing tmp = DefaultTokenMap.buildTokenToPrimaryAndRing(nodes, tokenFactory);
        Map<Token, Node> tokenToPrimary = tmp.tokenToPrimary;
        List<Token> ring = tmp.ring;
        LOG.debug("[{}] Rebuilt ring ({} tokens)", (Object)logPrefix, (Object)ring.size());
        Set<TokenRange> tokenRanges = DefaultTokenMap.buildTokenRanges(ring, tokenFactory);
        ImmutableSetMultimap.Builder tokenRangesByPrimary = ImmutableSetMultimap.builder();
        for (TokenRange range : tokenRanges) {
            if (range.isFullRing()) {
                assert (tokenToPrimary.size() == 1);
                tokenRangesByPrimary.put(tokenToPrimary.values().iterator().next(), range);
                continue;
            }
            tokenRangesByPrimary.put(tokenToPrimary.get(range.getEnd()), range);
        }
        Map<CqlIdentifier, Map<String, String>> replicationConfigs = DefaultTokenMap.buildReplicationConfigs(keyspaces, logPrefix);
        ImmutableMap.Builder<Map, KeyspaceTokenMap> keyspaceMapsBuilder = ImmutableMap.builder();
        for (Map map : ImmutableSet.copyOf(replicationConfigs.values())) {
            LOG.debug("[{}] Computing keyspace-level data for {}", (Object)logPrefix, (Object)map);
            keyspaceMapsBuilder.put(map, KeyspaceTokenMap.build(map, tokenToPrimary, ring, tokenRanges, tokenFactory, replicationStrategyFactory, logPrefix));
        }
        return new DefaultTokenMap(tokenFactory, tokenRanges, (SetMultimap<Node, TokenRange>)((Object)tokenRangesByPrimary.build()), replicationConfigs, keyspaceMapsBuilder.build(), logPrefix);
    }

    private DefaultTokenMap(TokenFactory tokenFactory, Set<TokenRange> tokenRanges, SetMultimap<Node, TokenRange> tokenRangesByPrimary, Map<CqlIdentifier, Map<String, String>> replicationConfigs, Map<Map<String, String>, KeyspaceTokenMap> keyspaceMaps, String logPrefix) {
        this.tokenFactory = tokenFactory;
        this.tokenRanges = tokenRanges;
        this.tokenRangesByPrimary = tokenRangesByPrimary;
        this.replicationConfigs = replicationConfigs;
        this.keyspaceMaps = keyspaceMaps;
        this.logPrefix = logPrefix;
    }

    public TokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    @NonNull
    public Token parse(@NonNull String tokenString) {
        return this.tokenFactory.parse(tokenString);
    }

    @Override
    @NonNull
    public String format(@NonNull Token token) {
        return this.tokenFactory.format(token);
    }

    @Override
    @NonNull
    public Token newToken(@Nullable Partitioner partitioner, ByteBuffer ... partitionKey) {
        if (partitioner == null) {
            partitioner = this.tokenFactory;
        }
        return partitioner.hash(RoutingKey.compose(partitionKey));
    }

    @Override
    @NonNull
    public TokenRange newTokenRange(@NonNull Token start, @NonNull Token end) {
        return this.tokenFactory.range(start, end);
    }

    @Override
    @NonNull
    public Set<TokenRange> getTokenRanges() {
        return this.tokenRanges;
    }

    @Override
    @NonNull
    public Set<TokenRange> getTokenRanges(@NonNull Node node) {
        return this.tokenRangesByPrimary.get((Object)node);
    }

    @Override
    @NonNull
    public Set<TokenRange> getTokenRanges(@NonNull CqlIdentifier keyspace, @NonNull Node replica) {
        KeyspaceTokenMap keyspaceMap = this.getKeyspaceMap(keyspace);
        return keyspaceMap == null ? Collections.emptySet() : keyspaceMap.getTokenRanges(replica);
    }

    @Override
    @NonNull
    public Set<Node> getReplicas(@NonNull CqlIdentifier keyspace, @Nullable Partitioner partitioner, @NonNull ByteBuffer partitionKey) {
        KeyspaceTokenMap keyspaceMap = this.getKeyspaceMap(keyspace);
        return keyspaceMap == null ? Collections.emptySet() : keyspaceMap.getReplicas(partitioner, partitionKey);
    }

    @Override
    @NonNull
    public Set<Node> getReplicas(@NonNull CqlIdentifier keyspace, @NonNull Token token) {
        KeyspaceTokenMap keyspaceMap = this.getKeyspaceMap(keyspace);
        return keyspaceMap == null ? Collections.emptySet() : keyspaceMap.getReplicas(token);
    }

    @Override
    @NonNull
    public String getPartitionerName() {
        return this.tokenFactory.getPartitionerName();
    }

    @Override
    @NonNull
    public Partitioner getPartitioner() {
        return this.tokenFactory;
    }

    private KeyspaceTokenMap getKeyspaceMap(CqlIdentifier keyspace) {
        Map<String, String> config = this.replicationConfigs.get(keyspace);
        return config == null ? null : this.keyspaceMaps.get(config);
    }

    public DefaultTokenMap refresh(@NonNull Collection<Node> nodes, @NonNull Collection<KeyspaceMetadata> keyspaces, @NonNull ReplicationStrategyFactory replicationStrategyFactory) {
        Map<CqlIdentifier, Map<String, String>> newReplicationConfigs = DefaultTokenMap.buildReplicationConfigs(keyspaces, this.logPrefix);
        if (newReplicationConfigs.equals(this.replicationConfigs)) {
            LOG.debug("[{}] Schema changes do not impact the token map, no refresh needed", (Object)this.logPrefix);
            return this;
        }
        ImmutableMap.Builder<Map, KeyspaceTokenMap> newKeyspaceMapsBuilder = ImmutableMap.builder();
        Map<Token, Node> tokenToPrimary = null;
        List<Token> ring = null;
        for (Map map : ImmutableSet.copyOf(newReplicationConfigs.values())) {
            KeyspaceTokenMap oldKeyspaceMap = this.keyspaceMaps.get(map);
            if (oldKeyspaceMap != null) {
                LOG.debug("[{}] Reusing existing keyspace-level data for {}", (Object)this.logPrefix, (Object)map);
                newKeyspaceMapsBuilder.put(map, oldKeyspaceMap);
                continue;
            }
            LOG.debug("[{}] Computing new keyspace-level data for {}", (Object)this.logPrefix, (Object)map);
            if (tokenToPrimary == null) {
                TokenToPrimaryAndRing tmp = DefaultTokenMap.buildTokenToPrimaryAndRing(nodes, this.tokenFactory);
                tokenToPrimary = tmp.tokenToPrimary;
                ring = tmp.ring;
            }
            newKeyspaceMapsBuilder.put(map, KeyspaceTokenMap.build(map, tokenToPrimary, ring, this.tokenRanges, this.tokenFactory, replicationStrategyFactory, this.logPrefix));
        }
        return new DefaultTokenMap(this.tokenFactory, this.tokenRanges, this.tokenRangesByPrimary, newReplicationConfigs, newKeyspaceMapsBuilder.build(), this.logPrefix);
    }

    private static TokenToPrimaryAndRing buildTokenToPrimaryAndRing(Collection<Node> nodes, TokenFactory tokenFactory) {
        ImmutableMap.Builder<Token, Node> tokenToPrimaryBuilder = ImmutableMap.builder();
        TreeSet<Token> sortedTokens = new TreeSet<Token>();
        for (Node node : nodes) {
            for (String tokenString : ((DefaultNode)node).getRawTokens()) {
                Token token = tokenFactory.parse(tokenString);
                sortedTokens.add(token);
                tokenToPrimaryBuilder.put(token, node);
            }
        }
        return new TokenToPrimaryAndRing(tokenToPrimaryBuilder.build(), ImmutableList.copyOf(sortedTokens));
    }

    private static Map<CqlIdentifier, Map<String, String>> buildReplicationConfigs(Collection<KeyspaceMetadata> keyspaces, String logPrefix) {
        ImmutableMap.Builder<CqlIdentifier, Map<String, String>> builder = ImmutableMap.builder();
        for (KeyspaceMetadata keyspace : keyspaces) {
            if (keyspace.isVirtual()) continue;
            builder.put(keyspace.getName(), keyspace.getReplication());
        }
        ImmutableMap<CqlIdentifier, Map<String, String>> result = builder.build();
        LOG.debug("[{}] Computing keyspace-level data for {}", (Object)logPrefix, result);
        return result;
    }

    private static Set<TokenRange> buildTokenRanges(List<Token> ring, TokenFactory factory) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (ring.size() == 1) {
            builder.add(factory.range(factory.minToken(), factory.minToken()));
        } else {
            for (int i = 0; i < ring.size(); ++i) {
                Token start = ring.get(i);
                Token end = ring.get((i + 1) % ring.size());
                builder.add(factory.range(start, end));
            }
        }
        return builder.build();
    }

    static class TokenToPrimaryAndRing {
        final Map<Token, Node> tokenToPrimary;
        final List<Token> ring;

        private TokenToPrimaryAndRing(Map<Token, Node> tokenToPrimary, List<Token> ring) {
            this.tokenToPrimary = tokenToPrimary;
            this.ring = ring;
        }
    }
}

