/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.internal.core.DseProtocolFeature;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.UnsupportedProtocolVersionException;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.DefaultProtocolFeature;
import com.datastax.oss.driver.internal.core.ProtocolFeature;
import com.datastax.oss.driver.internal.core.ProtocolVersionRegistry;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultProtocolVersionRegistry
implements ProtocolVersionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProtocolVersionRegistry.class);
    private static final List<ProtocolVersion> allVersions = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(DefaultProtocolVersion.values())).add(DseProtocolVersion.values())).build();
    @VisibleForTesting
    static final Version DSE_4_7_0 = Objects.requireNonNull(Version.parse("4.7.0"));
    @VisibleForTesting
    static final Version DSE_5_0_0 = Objects.requireNonNull(Version.parse("5.0.0"));
    @VisibleForTesting
    static final Version DSE_5_1_0 = Objects.requireNonNull(Version.parse("5.1.0"));
    @VisibleForTesting
    static final Version DSE_6_0_0 = Objects.requireNonNull(Version.parse("6.0.0"));
    @VisibleForTesting
    static final Version DSE_7_0_0 = Objects.requireNonNull(Version.parse("7.0.0"));
    private final String logPrefix;

    public DefaultProtocolVersionRegistry(String logPrefix) {
        this.logPrefix = logPrefix;
    }

    @Override
    public ProtocolVersion fromName(String name) {
        try {
            return DefaultProtocolVersion.valueOf(name);
        }
        catch (IllegalArgumentException noOssVersion) {
            try {
                return DseProtocolVersion.valueOf(name);
            }
            catch (IllegalArgumentException noDseVersion) {
                throw new IllegalArgumentException("Unknown protocol version name: " + name);
            }
        }
    }

    @Override
    public ProtocolVersion highestNonBeta() {
        ProtocolVersion highest = allVersions.get(allVersions.size() - 1);
        if (!highest.isBeta()) {
            return highest;
        }
        return this.downgrade(highest).orElseThrow(() -> new AssertionError((Object)"There should be at least one non-beta version"));
    }

    @Override
    public Optional<ProtocolVersion> downgrade(ProtocolVersion version) {
        int index = allVersions.indexOf(version);
        if (index < 0) {
            throw new AssertionError((Object)(version + " is not a known version"));
        }
        if (index == 0) {
            return Optional.empty();
        }
        ProtocolVersion previousVersion = allVersions.get(index - 1);
        return previousVersion.isBeta() ? this.downgrade(previousVersion) : Optional.of(previousVersion);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProtocolVersion highestCommon(Collection<Node> nodes) {
        void var4_7;
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one node");
        }
        LinkedHashSet<ProtocolVersion> candidates = new LinkedHashSet<ProtocolVersion>();
        for (ProtocolVersion protocolVersion : allVersions) {
            if (protocolVersion.isBeta()) continue;
            candidates.add(protocolVersion);
        }
        ImmutableList<ProtocolVersion> initialCandidates = ImmutableList.copyOf(candidates);
        for (Node node : nodes) {
            Version dseVersion = (Version)node.getExtras().get("DSE_VERSION");
            if (dseVersion != null) {
                LOG.debug("[{}] Node {} reports DSE version {}", new Object[]{this.logPrefix, node.getEndPoint(), dseVersion});
                dseVersion = dseVersion.nextStable();
                if (dseVersion.compareTo(DSE_4_7_0) < 0) {
                    throw new UnsupportedProtocolVersionException(node.getEndPoint(), String.format("Node %s reports DSE version %s, but the driver only supports 4.7.0 and above", node.getEndPoint(), dseVersion), initialCandidates);
                }
                if (dseVersion.compareTo(DSE_5_0_0) < 0) {
                    this.removeHigherThan(DefaultProtocolVersion.V3, null, candidates);
                    continue;
                }
                if (dseVersion.compareTo(DSE_5_1_0) < 0) {
                    this.removeHigherThan(DefaultProtocolVersion.V4, null, candidates);
                    continue;
                }
                if (dseVersion.compareTo(DSE_6_0_0) < 0) {
                    this.removeHigherThan(DefaultProtocolVersion.V4, DseProtocolVersion.DSE_V1, candidates);
                    continue;
                }
                if (dseVersion.compareTo(DSE_7_0_0) < 0) {
                    this.removeHigherThan(DefaultProtocolVersion.V4, DseProtocolVersion.DSE_V2, candidates);
                    continue;
                }
                this.removeHigherThan(DefaultProtocolVersion.V5, DseProtocolVersion.DSE_V2, candidates);
                continue;
            }
            Version cassandraVersion = node.getCassandraVersion();
            if (cassandraVersion == null) {
                LOG.warn("[{}] Node {} reports neither DSE version nor Cassandra version, ignoring it from optimal protocol version computation", (Object)this.logPrefix, (Object)node.getEndPoint());
                continue;
            }
            cassandraVersion = cassandraVersion.nextStable();
            LOG.debug("[{}] Node {} reports Cassandra version {}", new Object[]{this.logPrefix, node.getEndPoint(), cassandraVersion});
            if (cassandraVersion.compareTo(Version.V2_1_0) < 0) {
                throw new UnsupportedProtocolVersionException(node.getEndPoint(), String.format("Node %s reports Cassandra version %s, but the driver only supports 2.1.0 and above", node.getEndPoint(), cassandraVersion), ImmutableList.of(DefaultProtocolVersion.V3, DefaultProtocolVersion.V4));
            }
            if (cassandraVersion.compareTo(Version.V2_2_0) < 0) {
                this.removeHigherThan(DefaultProtocolVersion.V3, null, candidates);
                continue;
            }
            if (cassandraVersion.compareTo(Version.V4_0_0) < 0) {
                this.removeHigherThan(DefaultProtocolVersion.V4, null, candidates);
                continue;
            }
            this.removeHigherThan(DefaultProtocolVersion.V5, null, candidates);
        }
        Object var4_6 = null;
        for (ProtocolVersion candidate : candidates) {
            if (var4_7 != null && var4_7.getCode() >= candidate.getCode()) continue;
            ProtocolVersion protocolVersion = candidate;
        }
        if (var4_7 == null) {
            throw new UnsupportedProtocolVersionException(null, String.format("Could not determine a common protocol version, enable DEBUG logs for '%s' for more details", LOG.getName()), initialCandidates);
        }
        return var4_7;
    }

    private void removeHigherThan(DefaultProtocolVersion maxOssVersion, DseProtocolVersion maxDseVersion, Set<ProtocolVersion> candidates) {
        for (DefaultProtocolVersion defaultProtocolVersion : DefaultProtocolVersion.values()) {
            if (defaultProtocolVersion.compareTo(maxOssVersion) <= 0 || !candidates.remove(defaultProtocolVersion)) continue;
            LOG.debug("[{}] Excluding protocol {}", (Object)this.logPrefix, (Object)defaultProtocolVersion);
        }
        for (Enum enum_ : DseProtocolVersion.values()) {
            if (maxDseVersion != null && enum_.compareTo(maxDseVersion) <= 0 || !candidates.remove(enum_)) continue;
            LOG.debug("[{}] Excluding protocol {}", (Object)this.logPrefix, (Object)enum_);
        }
    }

    @Override
    public boolean supports(ProtocolVersion version, ProtocolFeature feature) {
        int code = version.getCode();
        if (DefaultProtocolFeature.SMALLINT_AND_TINYINT_TYPES.equals(feature) || DefaultProtocolFeature.DATE_TYPE.equals(feature) || DefaultProtocolFeature.UNSET_BOUND_VALUES.equals(feature)) {
            return DefaultProtocolVersion.V4.getCode() <= code;
        }
        if (DefaultProtocolFeature.PER_REQUEST_KEYSPACE.equals(feature)) {
            return DefaultProtocolVersion.V5.getCode() <= code && code < DseProtocolVersion.DSE_V1.getCode() || DseProtocolVersion.DSE_V2.getCode() <= code;
        }
        if (DefaultProtocolFeature.NOW_IN_SECONDS.equals(feature) || DefaultProtocolFeature.MODERN_FRAMING.equals(feature)) {
            return DefaultProtocolVersion.V5.getCode() <= code && code < DseProtocolVersion.DSE_V1.getCode();
        }
        if (DseProtocolFeature.CONTINUOUS_PAGING.equals(feature)) {
            return DseProtocolVersion.DSE_V1.getCode() <= code;
        }
        throw new IllegalArgumentException("Unhandled protocol feature: " + feature);
    }
}

