/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core;

import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.internal.core.PagingIterableWrapper;
import com.datastax.oss.driver.internal.core.cql.PagingIterableSpliterator;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Function;

public interface PagingIterable<ElementT>
extends Iterable<ElementT> {
    @NonNull
    public ColumnDefinitions getColumnDefinitions();

    @NonNull
    default public ExecutionInfo getExecutionInfo() {
        List<ExecutionInfo> infos = this.getExecutionInfos();
        return infos.get(infos.size() - 1);
    }

    @NonNull
    public List<ExecutionInfo> getExecutionInfos();

    @Nullable
    default public ElementT one() {
        Iterator iterator = this.iterator();
        return iterator.hasNext() ? (ElementT)iterator.next() : null;
    }

    @NonNull
    default public List<ElementT> all() {
        if (!this.iterator().hasNext()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithExpectedSize(this.getAvailableWithoutFetching());
        Iterables.addAll(result, this);
        return result;
    }

    public boolean isFullyFetched();

    public int getAvailableWithoutFetching();

    public boolean wasApplied();

    @NonNull
    default public <TargetElementT> PagingIterable<TargetElementT> map(Function<? super ElementT, ? extends TargetElementT> elementMapper) {
        return new PagingIterableWrapper<ElementT, TargetElementT>(this, elementMapper);
    }

    @Override
    @NonNull
    default public Spliterator<ElementT> spliterator() {
        return new PagingIterableSpliterator(this);
    }
}

