/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.request;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolFeatures;
import com.datastax.oss.protocol.internal.request.Prepare;

public class DsePrepareCodec
extends Message.Codec {
    public DsePrepareCodec(int protocolVersion) {
        super(9, protocolVersion);
        assert (protocolVersion >= 65);
    }

    @Override
    public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder, ProtocolFeatures protocolFeatures) {
        Prepare prepare = (Prepare)message;
        encoder.writeLongString(prepare.cqlQuery, dest);
        if (this.protocolVersion >= 66) {
            encoder.writeInt(prepare.keyspace == null ? 0 : 1, dest);
            if (prepare.keyspace != null) {
                encoder.writeString(prepare.keyspace, dest);
            }
        }
    }

    @Override
    public int encodedSize(Message message, ProtocolFeatures protocolFeatures) {
        Prepare prepare = (Prepare)message;
        int size = PrimitiveSizes.sizeOfLongString(prepare.cqlQuery);
        if (this.protocolVersion >= 66) {
            size += 4;
            if (prepare.keyspace != null) {
                size += PrimitiveSizes.sizeOfString(prepare.keyspace);
            }
        }
        return size;
    }

    @Override
    public <B> Message decode(B source, PrimitiveCodec<B> decoder, ProtocolFeatures protocolFeatures) {
        int flags;
        String cqlQuery = decoder.readLongString(source);
        String keyspace = null;
        if (this.protocolVersion >= 66 && ((flags = decoder.readInt(source)) & 1) == 1) {
            keyspace = decoder.readString(source);
        }
        return new Prepare(cqlQuery, keyspace);
    }
}

