/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.request;

import com.datastax.dse.protocol.internal.request.query.DseQueryOptionsCodec;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolFeatures;
import com.datastax.oss.protocol.internal.request.Execute;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;

public class DseExecuteCodec
extends Message.Codec {
    private final QueryOptions.Codec optionsCodec;

    public DseExecuteCodec(int protocolVersion) {
        super(10, protocolVersion);
        assert (protocolVersion >= 65);
        this.optionsCodec = new DseQueryOptionsCodec(protocolVersion);
    }

    @Override
    public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder, ProtocolFeatures protocolFeatures) {
        Execute execute = (Execute)message;
        encoder.writeShortBytes(execute.queryId, dest);
        if (this.protocolVersion >= 66) {
            encoder.writeShortBytes(execute.resultMetadataId, dest);
        }
        this.optionsCodec.encode(dest, execute.options, encoder);
    }

    @Override
    public int encodedSize(Message message, ProtocolFeatures protocolFeatures) {
        Execute execute = (Execute)message;
        int size = PrimitiveSizes.sizeOfShortBytes(execute.queryId);
        if (this.protocolVersion >= 66) {
            assert (execute.resultMetadataId != null);
            size += PrimitiveSizes.sizeOfShortBytes(execute.resultMetadataId);
        }
        return size += this.optionsCodec.encodedSize(execute.options);
    }

    @Override
    public <B> Message decode(B source, PrimitiveCodec<B> decoder, ProtocolFeatures protocolFeatures) {
        byte[] queryId = decoder.readShortBytes(source);
        byte[] resultMetadataId = this.protocolVersion >= 66 ? decoder.readShortBytes(source) : null;
        QueryOptions options = this.optionsCodec.decode(source, decoder);
        return new Execute(queryId, resultMetadataId, options);
    }
}

