/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.metadata.schema.parsing;

import com.datastax.dse.driver.api.core.metadata.schema.DseAggregateMetadata;
import com.datastax.dse.driver.api.core.metadata.schema.DseFunctionMetadata;
import com.datastax.dse.driver.api.core.metadata.schema.DseKeyspaceMetadata;
import com.datastax.dse.driver.api.core.metadata.schema.DseTableMetadata;
import com.datastax.dse.driver.api.core.metadata.schema.DseViewMetadata;
import com.datastax.dse.driver.internal.core.metadata.schema.DefaultDseKeyspaceMetadata;
import com.datastax.dse.driver.internal.core.metadata.schema.parsing.DseAggregateParser;
import com.datastax.dse.driver.internal.core.metadata.schema.parsing.DseFunctionParser;
import com.datastax.dse.driver.internal.core.metadata.schema.parsing.DseTableParser;
import com.datastax.dse.driver.internal.core.metadata.schema.parsing.DseViewParser;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.AggregateMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.FunctionSignature;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.CassandraSchemaParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SchemaParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SimpleJsonParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.UserDefinedTypeParser;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaRows;
import com.datastax.oss.driver.internal.core.metadata.schema.refresh.SchemaRefresh;
import com.datastax.oss.driver.internal.core.util.NanoTime;
import com.datastax.oss.driver.shaded.guava.common.base.MoreObjects;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.Multimap;
import java.util.Collections;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DseSchemaParser
implements SchemaParser {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraSchemaParser.class);
    private final SchemaRows rows;
    private final UserDefinedTypeParser userDefinedTypeParser;
    private final DseTableParser tableParser;
    private final DseViewParser viewParser;
    private final DseFunctionParser functionParser;
    private final DseAggregateParser aggregateParser;
    private final String logPrefix;
    private final long startTimeNs = System.nanoTime();

    public DseSchemaParser(SchemaRows rows, InternalDriverContext context) {
        this.rows = rows;
        this.logPrefix = context.getSessionName();
        this.userDefinedTypeParser = new UserDefinedTypeParser(rows.dataTypeParser(), context);
        this.tableParser = new DseTableParser(rows, context);
        this.viewParser = new DseViewParser(rows, context);
        this.functionParser = new DseFunctionParser(rows.dataTypeParser(), context);
        this.aggregateParser = new DseAggregateParser(rows.dataTypeParser(), context);
    }

    @Override
    public SchemaRefresh parse() {
        DseKeyspaceMetadata keyspace;
        ImmutableMap.Builder<CqlIdentifier, DseKeyspaceMetadata> keyspacesBuilder = ImmutableMap.builder();
        for (AdminRow row : this.rows.keyspaces()) {
            keyspace = this.parseKeyspace(row);
            keyspacesBuilder.put(keyspace.getName(), keyspace);
        }
        for (AdminRow row : this.rows.virtualKeyspaces()) {
            keyspace = this.parseVirtualKeyspace(row);
            keyspacesBuilder.put(keyspace.getName(), keyspace);
        }
        SchemaRefresh refresh = new SchemaRefresh(keyspacesBuilder.build());
        LOG.debug("[{}] Schema parsing took {}", (Object)this.logPrefix, (Object)NanoTime.formatTimeSince(this.startTimeNs));
        return refresh;
    }

    private DseKeyspaceMetadata parseKeyspace(AdminRow keyspaceRow) {
        Map<String, String> replicationOptions;
        CqlIdentifier keyspaceId = CqlIdentifier.fromInternal(keyspaceRow.getString("keyspace_name"));
        boolean durableWrites = MoreObjects.firstNonNull(keyspaceRow.getBoolean("durable_writes"), false);
        String graphEngine = keyspaceRow.getString("graph_engine");
        if (keyspaceRow.contains("strategy_class")) {
            String strategyClass = keyspaceRow.getString("strategy_class");
            Map<String, String> strategyOptions = SimpleJsonParser.parseStringMap(keyspaceRow.getString("strategy_options"));
            replicationOptions = ImmutableMap.builder().putAll(strategyOptions).put("class", strategyClass).build();
        } else {
            replicationOptions = keyspaceRow.getMapOfStringToString("replication");
        }
        Map<CqlIdentifier, UserDefinedType> types = this.parseTypes(keyspaceId);
        return new DefaultDseKeyspaceMetadata(keyspaceId, durableWrites, false, graphEngine, replicationOptions, types, this.parseTables(keyspaceId, types), this.parseViews(keyspaceId, types), this.parseFunctions(keyspaceId, types), this.parseAggregates(keyspaceId, types));
    }

    private Map<CqlIdentifier, UserDefinedType> parseTypes(CqlIdentifier keyspaceId) {
        return this.userDefinedTypeParser.parse(this.rows.types().get(keyspaceId), keyspaceId);
    }

    private Map<CqlIdentifier, TableMetadata> parseTables(CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> types) {
        ImmutableMap.Builder<CqlIdentifier, DseTableMetadata> tablesBuilder = ImmutableMap.builder();
        Multimap<CqlIdentifier, AdminRow> vertices = this.rows.vertices().get(keyspaceId);
        Multimap<CqlIdentifier, AdminRow> edges = this.rows.edges().get(keyspaceId);
        for (AdminRow tableRow : this.rows.tables().get(keyspaceId)) {
            DseTableMetadata table = this.tableParser.parseTable(tableRow, keyspaceId, types, vertices, edges);
            if (table == null) continue;
            tablesBuilder.put(table.getName(), table);
        }
        return tablesBuilder.build();
    }

    private Map<CqlIdentifier, ViewMetadata> parseViews(CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> types) {
        ImmutableMap.Builder<CqlIdentifier, DseViewMetadata> viewsBuilder = ImmutableMap.builder();
        for (AdminRow viewRow : this.rows.views().get(keyspaceId)) {
            DseViewMetadata view = this.viewParser.parseView(viewRow, keyspaceId, types);
            if (view == null) continue;
            viewsBuilder.put(view.getName(), view);
        }
        return viewsBuilder.build();
    }

    private Map<FunctionSignature, FunctionMetadata> parseFunctions(CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> types) {
        ImmutableMap.Builder<FunctionSignature, DseFunctionMetadata> functionsBuilder = ImmutableMap.builder();
        for (AdminRow functionRow : this.rows.functions().get(keyspaceId)) {
            DseFunctionMetadata function = this.functionParser.parseFunction(functionRow, keyspaceId, types);
            if (function == null) continue;
            functionsBuilder.put(function.getSignature(), function);
        }
        return functionsBuilder.build();
    }

    private Map<FunctionSignature, AggregateMetadata> parseAggregates(CqlIdentifier keyspaceId, Map<CqlIdentifier, UserDefinedType> types) {
        ImmutableMap.Builder<FunctionSignature, DseAggregateMetadata> aggregatesBuilder = ImmutableMap.builder();
        for (AdminRow aggregateRow : this.rows.aggregates().get(keyspaceId)) {
            DseAggregateMetadata aggregate = this.aggregateParser.parseAggregate(aggregateRow, keyspaceId, types);
            if (aggregate == null) continue;
            aggregatesBuilder.put(aggregate.getSignature(), aggregate);
        }
        return aggregatesBuilder.build();
    }

    private DseKeyspaceMetadata parseVirtualKeyspace(AdminRow keyspaceRow) {
        CqlIdentifier keyspaceId = CqlIdentifier.fromInternal(keyspaceRow.getString("keyspace_name"));
        boolean durableWrites = MoreObjects.firstNonNull(keyspaceRow.getBoolean("durable_writes"), false);
        return new DefaultDseKeyspaceMetadata(keyspaceId, durableWrites, true, null, Collections.emptyMap(), Collections.emptyMap(), this.parseVirtualTables(keyspaceId), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    private Map<CqlIdentifier, TableMetadata> parseVirtualTables(CqlIdentifier keyspaceId) {
        ImmutableMap.Builder<CqlIdentifier, DseTableMetadata> tablesBuilder = ImmutableMap.builder();
        for (AdminRow tableRow : this.rows.virtualTables().get(keyspaceId)) {
            DseTableMetadata table = this.tableParser.parseVirtualTable(tableRow, keyspaceId);
            if (table == null) continue;
            tablesBuilder.put(table.getName(), table);
        }
        return tablesBuilder.build();
    }
}

