/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.utils;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.utils.SvgCssUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class TransformUtils {
    private static final String MATRIX = "MATRIX";
    private static final String ROTATE = "ROTATE";
    private static final String SCALE = "SCALE";
    private static final String SKEWX = "SKEWX";
    private static final String SKEWY = "SKEWY";
    private static final String TRANSLATE = "TRANSLATE";

    private TransformUtils() {
    }

    public static AffineTransform parseTransform(String transform) {
        if (transform == null) {
            throw new SvgProcessingException("The transformation value is null.");
        }
        if (transform.isEmpty()) {
            throw new SvgProcessingException("The transformation value is empty.");
        }
        AffineTransform matrix = new AffineTransform();
        List<String> listWithTransformations = TransformUtils.splitString(transform);
        for (String transformation : listWithTransformations) {
            AffineTransform newMatrix = TransformUtils.transformationStringToMatrix(transformation);
            if (newMatrix == null) continue;
            matrix.concatenate(newMatrix);
        }
        return matrix;
    }

    private static List<String> splitString(String transform) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(transform, ")", false);
        while (tokenizer.hasMoreTokens()) {
            String trim = tokenizer.nextToken().trim();
            if (trim == null || trim.isEmpty()) continue;
            if (trim.startsWith(",")) {
                trim = trim.substring(1).trim();
            }
            list.add(trim + ")");
        }
        return list;
    }

    private static AffineTransform transformationStringToMatrix(String transformation) {
        String name = StringNormalizer.toUpperCase(TransformUtils.getNameFromString(transformation));
        if (name.isEmpty()) {
            throw new SvgProcessingException("Transformation declaration is not formed correctly.");
        }
        switch (name) {
            case "MATRIX": {
                return TransformUtils.createMatrixTransformation(TransformUtils.getValuesFromTransformationString(transformation));
            }
            case "TRANSLATE": {
                return TransformUtils.createTranslateTransformation(TransformUtils.getValuesFromTransformationString(transformation));
            }
            case "SCALE": {
                return TransformUtils.createScaleTransformation(TransformUtils.getValuesFromTransformationString(transformation));
            }
            case "ROTATE": {
                return TransformUtils.createRotationTransformation(TransformUtils.getValuesFromTransformationString(transformation));
            }
            case "SKEWX": {
                return TransformUtils.createSkewXTransformation(TransformUtils.getValuesFromTransformationString(transformation));
            }
            case "SKEWY": {
                return TransformUtils.createSkewYTransformation(TransformUtils.getValuesFromTransformationString(transformation));
            }
        }
        throw new SvgProcessingException("Unsupported type of transformation.");
    }

    private static AffineTransform createSkewYTransformation(List<String> values) {
        if (values.size() != 1) {
            throw new SvgProcessingException("Transformation doesn't contain the right number of values.");
        }
        double tan = Math.tan(Math.toRadians(TransformUtils.parseTransformationValue(values.get(0))));
        return new AffineTransform(1.0, tan, 0.0, 1.0, 0.0, 0.0);
    }

    private static AffineTransform createSkewXTransformation(List<String> values) {
        if (values.size() != 1) {
            throw new SvgProcessingException("Transformation doesn't contain the right number of values.");
        }
        double tan = Math.tan(Math.toRadians(TransformUtils.parseTransformationValue(values.get(0))));
        return new AffineTransform(1.0, 0.0, tan, 1.0, 0.0, 0.0);
    }

    private static AffineTransform createRotationTransformation(List<String> values) {
        if (values.size() != 1 && values.size() != 3) {
            throw new SvgProcessingException("Transformation doesn't contain the right number of values.");
        }
        double angle = Math.toRadians(TransformUtils.parseTransformationValue(values.get(0)));
        if (values.size() == 3) {
            float centerX = CssDimensionParsingUtils.parseAbsoluteLength(values.get(1));
            float centerY = CssDimensionParsingUtils.parseAbsoluteLength(values.get(2));
            return AffineTransform.getRotateInstance(angle, centerX, centerY);
        }
        return AffineTransform.getRotateInstance(angle);
    }

    private static AffineTransform createScaleTransformation(List<String> values) {
        if (values.size() == 0 || values.size() > 2) {
            throw new SvgProcessingException("Transformation doesn't contain the right number of values.");
        }
        float scaleX = CssDimensionParsingUtils.parseRelativeValue(values.get(0), 1.0f);
        float scaleY = values.size() == 2 ? CssDimensionParsingUtils.parseRelativeValue(values.get(1), 1.0f) : scaleX;
        return AffineTransform.getScaleInstance(scaleX, scaleY);
    }

    private static AffineTransform createTranslateTransformation(List<String> values) {
        if (values.size() == 0 || values.size() > 2) {
            throw new SvgProcessingException("Transformation doesn't contain the right number of values.");
        }
        float translateX = CssDimensionParsingUtils.parseAbsoluteLength(values.get(0));
        float translateY = values.size() == 2 ? CssDimensionParsingUtils.parseAbsoluteLength(values.get(1)) : 0.0f;
        return AffineTransform.getTranslateInstance(translateX, translateY);
    }

    private static AffineTransform createMatrixTransformation(List<String> values) {
        if (values.size() != 6) {
            throw new SvgProcessingException("Transformation doesn't contain the right number of values.");
        }
        float a = Float.parseFloat(values.get(0));
        float b = Float.parseFloat(values.get(1));
        float c = Float.parseFloat(values.get(2));
        float d = Float.parseFloat(values.get(3));
        float e = CssDimensionParsingUtils.parseAbsoluteLength(values.get(4));
        float f = CssDimensionParsingUtils.parseAbsoluteLength(values.get(5));
        return new AffineTransform(a, b, c, d, e, f);
    }

    private static String getNameFromString(String transformation) {
        int indexOfParenthesis = transformation.indexOf("(");
        if (indexOfParenthesis == -1) {
            throw new SvgProcessingException("Transformation declaration is not formed correctly.");
        }
        return transformation.substring(0, transformation.indexOf("("));
    }

    private static List<String> getValuesFromTransformationString(String transformation) {
        String numbers = transformation.substring(transformation.indexOf(40) + 1, transformation.indexOf(41));
        return SvgCssUtils.splitValueList(numbers);
    }

    private static float parseTransformationValue(String valueStr) {
        Float valueParsed = CssDimensionParsingUtils.parseFloat(valueStr);
        if (valueParsed == null) {
            throw new SvgProcessingException(MessageFormatUtil.format("Invalid transformation value: {0}", valueStr));
        }
        return valueParsed.floatValue();
    }
}

