/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.utils;

import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.geom.Vector;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import com.itextpdf.svg.renderers.SvgDrawContext;

public class SvgCoordinateUtils {
    public static String[] makeRelativeOperatorCoordinatesAbsolute(String[] relativeCoordinates, double[] currentCoordinates) {
        if (relativeCoordinates.length % currentCoordinates.length != 0) {
            throw new IllegalArgumentException("Array of current coordinates must have length that is divisible by the length of the array with current coordinates");
        }
        String[] absoluteOperators = new String[relativeCoordinates.length];
        int i = 0;
        while (i < relativeCoordinates.length) {
            int j = 0;
            while (j < currentCoordinates.length) {
                double relativeDouble = Double.parseDouble(relativeCoordinates[i]);
                absoluteOperators[i] = Double.toString(relativeDouble += currentCoordinates[j]);
                ++j;
                ++i;
            }
        }
        return absoluteOperators;
    }

    public static double calculateAngleBetweenTwoVectors(Vector vectorA, Vector vectorB) {
        return Math.acos((double)vectorA.dot(vectorB) / ((double)vectorA.length() * (double)vectorB.length()));
    }

    public static double getCoordinateForUserSpaceOnUse(String attributeValue, double defaultValue, double start, double length, float em, float rem) {
        UnitValue unitValue = CssDimensionParsingUtils.parseLengthValueToPt(attributeValue, em, rem);
        double absoluteValue = unitValue == null ? defaultValue : (unitValue.getUnitType() == 2 ? start + length * (double)unitValue.getValue() / 100.0 : (double)unitValue.getValue());
        return absoluteValue;
    }

    public static double getCoordinateForObjectBoundingBox(String attributeValue, double defaultValue) {
        int unitsPosition;
        if (CssTypesValidationUtils.isPercentageValue(attributeValue)) {
            return CssDimensionParsingUtils.parseRelativeValue(attributeValue, 1.0f);
        }
        if ((CssTypesValidationUtils.isNumber(attributeValue) || CssTypesValidationUtils.isMetricValue(attributeValue) || CssTypesValidationUtils.isRelativeValue(attributeValue)) && (unitsPosition = CssDimensionParsingUtils.determinePositionBetweenValueAndUnit(attributeValue)) > 0) {
            return CssDimensionParsingUtils.parseDouble(attributeValue.substring(0, unitsPosition));
        }
        return defaultValue;
    }

    public static float calculateNormalizedDiagonalLength(SvgDrawContext context) {
        float viewPortHeight = context.getCurrentViewPort().getHeight();
        float viewPortWidth = context.getCurrentViewPort().getWidth();
        return (float)(Math.sqrt(viewPortHeight * viewPortHeight + viewPortWidth * viewPortWidth) / Math.sqrt(2.0));
    }

    public static Rectangle applyViewBox(Rectangle viewBox, Rectangle currentViewPort, String align, String meetOrSlice) {
        double yOffset;
        double xOffset;
        double scaleHeight;
        double scaleWidth;
        if (currentViewPort == null) {
            throw new IllegalArgumentException("The current viewport is null. The viewBox applying could not be processed.");
        }
        if (viewBox == null || viewBox.getWidth() <= 0.0f || viewBox.getHeight() <= 0.0f) {
            throw new IllegalArgumentException("The viewBox is incorrect. The viewBox applying could not be processed.");
        }
        if (align == null || meetOrSlice != null && !"meet".equals(meetOrSlice) && !"slice".equals(meetOrSlice)) {
            return SvgCoordinateUtils.applyViewBox(viewBox, currentViewPort, "xmidymid", "meet");
        }
        if ("none".equalsIgnoreCase(align)) {
            scaleWidth = (double)currentViewPort.getWidth() / (double)viewBox.getWidth();
            scaleHeight = (double)currentViewPort.getHeight() / (double)viewBox.getHeight();
        } else {
            double scale;
            scaleWidth = scale = SvgCoordinateUtils.getScaleWidthHeight(viewBox, currentViewPort, meetOrSlice);
            scaleHeight = scale;
        }
        Rectangle appliedViewBox = new Rectangle(viewBox.getX(), viewBox.getY(), (float)((double)viewBox.getWidth() * scaleWidth), (float)((double)viewBox.getHeight() * scaleHeight));
        double minXOffset = (double)currentViewPort.getX() - (double)appliedViewBox.getX() * scaleWidth;
        double minYOffset = (double)currentViewPort.getY() - (double)appliedViewBox.getY() * scaleHeight;
        double midXOffset = (double)currentViewPort.getX() + (double)currentViewPort.getWidth() / 2.0 - ((double)appliedViewBox.getX() * scaleWidth + (double)appliedViewBox.getWidth() / 2.0);
        double midYOffset = (double)currentViewPort.getY() + (double)currentViewPort.getHeight() / 2.0 - ((double)appliedViewBox.getY() * scaleHeight + (double)appliedViewBox.getHeight() / 2.0);
        double maxXOffset = (double)currentViewPort.getX() + (double)currentViewPort.getWidth() - ((double)appliedViewBox.getX() * scaleWidth + (double)appliedViewBox.getWidth());
        double maxYOffset = (double)currentViewPort.getY() + (double)currentViewPort.getHeight() - ((double)appliedViewBox.getY() * scaleHeight + (double)appliedViewBox.getHeight());
        switch (StringNormalizer.toLowerCase(align)) {
            case "none": 
            case "xminymin": {
                xOffset = minXOffset;
                yOffset = minYOffset;
                break;
            }
            case "xminymid": {
                xOffset = minXOffset;
                yOffset = midYOffset;
                break;
            }
            case "xminymax": {
                xOffset = minXOffset;
                yOffset = maxYOffset;
                break;
            }
            case "xmidymin": {
                xOffset = midXOffset;
                yOffset = minYOffset;
                break;
            }
            case "xmidymax": {
                xOffset = midXOffset;
                yOffset = maxYOffset;
                break;
            }
            case "xmaxymin": {
                xOffset = maxXOffset;
                yOffset = minYOffset;
                break;
            }
            case "xmaxymid": {
                xOffset = maxXOffset;
                yOffset = midYOffset;
                break;
            }
            case "xmaxymax": {
                xOffset = maxXOffset;
                yOffset = maxYOffset;
                break;
            }
            case "xmidymid": {
                xOffset = midXOffset;
                yOffset = midYOffset;
                break;
            }
            default: {
                return SvgCoordinateUtils.applyViewBox(viewBox, currentViewPort, "xmidymid", "meet");
            }
        }
        appliedViewBox.moveRight((float)xOffset);
        appliedViewBox.moveUp((float)yOffset);
        appliedViewBox.setX((float)((double)appliedViewBox.getX() * scaleWidth));
        appliedViewBox.setY((float)((double)appliedViewBox.getY() * scaleHeight));
        return appliedViewBox;
    }

    private static double getScaleWidthHeight(Rectangle viewBox, Rectangle currentViewPort, String meetOrSlice) {
        double scaleWidth = (double)currentViewPort.getWidth() / (double)viewBox.getWidth();
        double scaleHeight = (double)currentViewPort.getHeight() / (double)viewBox.getHeight();
        if ("slice".equalsIgnoreCase(meetOrSlice)) {
            return Math.max(scaleWidth, scaleHeight);
        }
        if ("meet".equalsIgnoreCase(meetOrSlice) || meetOrSlice == null) {
            return Math.min(scaleWidth, scaleHeight);
        }
        throw new IllegalStateException("The meetOrSlice argument is incorrect. It must be `meet`, `slice` or null.");
    }
}

