/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.utils;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import java.util.List;

public class DrawUtils {
    private DrawUtils() {
    }

    public static void arc(double x1, double y1, double x2, double y2, double startAng, double extent, PdfCanvas cv) {
        DrawUtils.arc(x1, y1, x2, y2, startAng, extent, cv, null);
    }

    public static void arc(double x1, double y1, double x2, double y2, double startAng, double extent, PdfCanvas cv, AffineTransform transform) {
        List<double[]> ar = PdfCanvas.bezierArc(x1, y1, x2, y2, startAng, extent);
        if (!ar.isEmpty()) {
            for (double[] pt : ar) {
                if (transform != null) {
                    transform.transform(pt, 0, pt, 0, pt.length / 2);
                }
                cv.curveTo(pt[2], pt[3], pt[4], pt[5], pt[6], pt[7]);
            }
        }
    }

    public static void doStrokeOrFillForClosedFigure(String fillRuleRawValue, PdfCanvas currentCanvas, boolean doStroke) {
        if ("evenodd".equalsIgnoreCase(fillRuleRawValue)) {
            if (doStroke) {
                currentCanvas.closePathEoFillStroke();
            } else {
                currentCanvas.eoFill();
            }
        } else if (doStroke) {
            currentCanvas.closePathFillStroke();
        } else {
            currentCanvas.fill();
        }
    }
}

