/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.path.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.svg.renderers.path.impl.AbstractPathShape;
import java.util.Arrays;

public class LineTo
extends AbstractPathShape {
    static final int ARGUMENT_SIZE = 2;

    public LineTo() {
        this(false);
    }

    public LineTo(boolean relative) {
        super(relative);
    }

    @Override
    public void draw() {
        double x = this.parseHorizontalLength(this.coordinates[0]);
        double y = this.parseVerticalLength(this.coordinates[1]);
        double[] points = new double[]{x, y};
        this.applyTransform(points);
        this.context.getCurrentCanvas().lineTo(points[0], points[1]);
    }

    @Override
    public void setCoordinates(String[] inputCoordinates, Point startPoint) {
        if (inputCoordinates.length != 2) {
            throw new IllegalArgumentException(MessageFormatUtil.format("(x y)+ parameters are expected for lineTo operator. Got: {0}", Arrays.toString(inputCoordinates)));
        }
        this.coordinates = new String[]{inputCoordinates[0], inputCoordinates[1]};
        if (this.isRelative()) {
            this.coordinates = this.copier.makeCoordinatesAbsolute(this.coordinates, new double[]{startPoint.getX(), startPoint.getY()});
        }
    }
}

