/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.ISvgTextNodeRenderer;
import com.itextpdf.svg.renderers.impl.TextSvgBranchRenderer;
import com.itextpdf.svg.utils.SvgTextProperties;
import com.itextpdf.svg.utils.SvgTextUtil;
import com.itextpdf.svg.utils.TextRectangle;

public class TextLeafSvgNodeRenderer
extends AbstractSvgNodeRenderer
implements ISvgTextNodeRenderer {
    private final Text text = new Text("");

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        TextLeafSvgNodeRenderer copy = new TextLeafSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }

    @Override
    @Deprecated
    public float getTextContentLength(float parentFontSize, PdfFont font) {
        float contentLength = 0.0f;
        if (font != null && this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text_content")) {
            float fontSize = SvgTextUtil.resolveFontSize(this, parentFontSize);
            String content = (String)this.attributesAndStyles.get("text_content");
            contentLength = font.getWidth(content, fontSize);
        }
        return contentLength;
    }

    @Override
    @Deprecated
    public float[] getRelativeTranslation() {
        return new float[]{0.0f, 0.0f};
    }

    @Override
    @Deprecated
    public boolean containsRelativeMove() {
        return false;
    }

    @Override
    @Deprecated
    public boolean containsAbsolutePositionChange() {
        return false;
    }

    @Override
    @Deprecated
    public float[][] getAbsolutePositionChanges() {
        float[] part = new float[]{0.0f};
        return new float[][]{part, part};
    }

    @Override
    public TextRectangle getTextRectangle(SvgDrawContext context, Point startPoint) {
        if (this.getParent() instanceof TextSvgBranchRenderer && startPoint != null) {
            LineRenderer lineRenderer = this.layoutText(context);
            if (lineRenderer == null) {
                return null;
            }
            Rectangle textBBox = lineRenderer.getOccupiedAreaBBox();
            float textLength = textBBox.getWidth();
            float textHeight = textBBox.getHeight();
            return new TextRectangle((float)startPoint.getX(), (float)startPoint.getY() - lineRenderer.getMaxAscent(), textLength, textHeight, (float)startPoint.getY());
        }
        return null;
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        return null;
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text_content")) {
            this.text.setText((String)this.attributesAndStyles.get("text_content"));
            ((TextSvgBranchRenderer)this.getParent()).applyFontProperties(this.text, context);
            ((TextSvgBranchRenderer)this.getParent()).applyTextRenderingMode(this.text);
            this.applyTransform(context);
            this.applyGraphicsState(context);
            ((TextSvgBranchRenderer)this.getParent()).addTextChild(this.text, context);
        }
    }

    @Override
    protected boolean canElementFill() {
        return false;
    }

    private void applyTransform(SvgDrawContext context) {
        AffineTransform transform = context.getRootTransform();
        this.text.setHorizontalScaling((float)transform.getScaleX());
        this.text.setProperty(76, transform.getScaleY());
        this.text.setProperty(65, new float[]{(float)transform.getShearX(), (float)transform.getShearY()});
    }

    private void applyGraphicsState(SvgDrawContext context) {
        SvgTextProperties textProperties = context.getSvgTextProperties();
        this.text.setFontColor(textProperties.getFillColor(), textProperties.getFillOpacity());
        this.text.setStrokeWidth(textProperties.getLineWidth());
        this.text.setStrokeColor(textProperties.getStrokeColor(), textProperties.getStrokeOpacity());
        this.text.setDashPattern(textProperties.getDashArray(), textProperties.getDashPhase());
        this.text.setProperty(74, textProperties.getTextDecoration());
    }

    private LineRenderer layoutText(SvgDrawContext context) {
        if (this.attributesAndStyles != null && this.attributesAndStyles.containsKey("text_content")) {
            this.text.setText(((String)this.attributesAndStyles.get("text_content")).replace(" ", "\u00a0"));
            ((TextSvgBranchRenderer)this.getParent()).applyFontProperties(this.text, context);
            Paragraph paragraph = new Paragraph();
            paragraph.setProperty(26, true);
            ParagraphRenderer paragraphRenderer = new ParagraphRenderer(paragraph);
            paragraph.setNextRenderer(paragraphRenderer);
            paragraph.add(this.text);
            PdfFormXObject xObject = new PdfFormXObject(new Rectangle(1000000.0f, 0.0f));
            try (Canvas canvas = new Canvas(new PdfCanvas(xObject, context.getCurrentCanvas().getDocument()), xObject.getBBox().toRectangle());){
                canvas.add(paragraph);
            }
            return paragraphRenderer.getLines().get(0);
        }
        return null;
    }
}

