/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSet;
import com.itextpdf.styledxmlparser.resolver.font.BasicFontProvider;
import com.itextpdf.styledxmlparser.resolver.resource.ResourceResolver;
import com.itextpdf.svg.css.SvgCssContext;
import com.itextpdf.svg.exceptions.SvgProcessingException;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.utils.SvgTextProperties;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;

public class SvgDrawContext {
    private final Map<String, ISvgNodeRenderer> namedObjects = new HashMap<String, ISvgNodeRenderer>();
    private final Deque<PdfCanvas> canvases = new LinkedList<PdfCanvas>();
    private final Deque<Rectangle> viewports = new LinkedList<Rectangle>();
    private final Stack<String> useIds = new Stack();
    private final Stack<String> patternIds = new Stack();
    private final ResourceResolver resourceResolver;
    private final FontProvider fontProvider;
    private SvgTextProperties textProperties = new SvgTextProperties();
    private FontSet tempFonts;
    private SvgCssContext cssContext;
    private AffineTransform rootTransform;
    private AffineTransform clippingElementTransform = new AffineTransform();
    private float[] textMove = new float[]{0.0f, 0.0f};
    private float[] relativePosition;
    private Rectangle customViewport;

    public SvgDrawContext(ResourceResolver resourceResolver, FontProvider fontProvider) {
        if (resourceResolver == null) {
            resourceResolver = new ResourceResolver(null);
        }
        this.resourceResolver = resourceResolver;
        if (fontProvider == null) {
            fontProvider = new BasicFontProvider();
        }
        this.fontProvider = fontProvider;
        this.cssContext = new SvgCssContext();
    }

    public Rectangle getCustomViewport() {
        return this.customViewport;
    }

    public void setCustomViewport(Rectangle customViewport) {
        this.customViewport = customViewport;
    }

    public PdfCanvas getCurrentCanvas() {
        return this.canvases.getFirst();
    }

    public PdfCanvas popCanvas() {
        PdfCanvas canvas = this.canvases.getFirst();
        this.canvases.removeFirst();
        return canvas;
    }

    public void pushCanvas(PdfCanvas canvas) {
        this.canvases.addFirst(canvas);
    }

    public int size() {
        return this.canvases.size();
    }

    public void addViewPort(Rectangle viewPort) {
        this.viewports.addFirst(viewPort);
    }

    public Rectangle getCurrentViewPort() {
        if (this.viewports.isEmpty()) {
            return null;
        }
        return this.viewports.getFirst();
    }

    public Rectangle getRootViewPort() {
        return this.viewports.getLast();
    }

    public void removeCurrentViewPort() {
        if (!this.viewports.isEmpty()) {
            this.viewports.removeFirst();
        }
    }

    public void addNamedObject(String name, ISvgNodeRenderer namedObject) {
        if (namedObject == null) {
            throw new SvgProcessingException("A named object can't be null.");
        }
        if (name == null || name.isEmpty()) {
            throw new SvgProcessingException("The name of the named object can't be null or empty.");
        }
        if (!this.namedObjects.containsKey(name)) {
            this.namedObjects.put(name, namedObject);
        }
    }

    public ISvgNodeRenderer getNamedObject(String name) {
        return this.namedObjects.get(name);
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void addNamedObjects(Map<String, ISvgNodeRenderer> namedObjects) {
        this.namedObjects.putAll(namedObjects);
    }

    public FontProvider getFontProvider() {
        return this.fontProvider;
    }

    public FontSet getTempFonts() {
        return this.tempFonts;
    }

    public void setTempFonts(FontSet tempFonts) {
        this.tempFonts = tempFonts;
    }

    public boolean isIdUsedByUseTagBefore(String elementId) {
        return this.useIds.contains(elementId);
    }

    public void addUsedId(String elementId) {
        this.useIds.push(elementId);
    }

    public void removeUsedId(String elementId) {
        this.useIds.pop();
    }

    @Deprecated
    public AffineTransform getLastTextTransform() {
        return new AffineTransform();
    }

    @Deprecated
    public void setLastTextTransform(AffineTransform newTransform) {
    }

    public AffineTransform getRootTransform() {
        if (this.rootTransform == null) {
            this.rootTransform = new AffineTransform();
        }
        return this.rootTransform;
    }

    public void setRootTransform(AffineTransform newTransform) {
        this.rootTransform = newTransform;
    }

    public float[] getTextMove() {
        return this.textMove;
    }

    public void resetTextMove() {
        this.textMove = new float[]{0.0f, 0.0f};
    }

    public void addTextMove(float additionalMoveX, float additionalMoveY) {
        this.textMove[0] = this.textMove[0] + additionalMoveX;
        this.textMove[1] = this.textMove[1] + additionalMoveY;
    }

    public AffineTransform getCurrentCanvasTransform() {
        Matrix currentTransform = this.getCurrentCanvas().getGraphicsState().getCtm();
        if (currentTransform != null) {
            return new AffineTransform(currentTransform.get(0), currentTransform.get(1), currentTransform.get(3), currentTransform.get(4), currentTransform.get(6), currentTransform.get(7));
        }
        return new AffineTransform();
    }

    public SvgCssContext getCssContext() {
        return this.cssContext;
    }

    public void setCssContext(SvgCssContext cssContext) {
        this.cssContext = cssContext;
    }

    public boolean pushPatternId(String patternId) {
        if (this.patternIds.contains(patternId)) {
            return false;
        }
        this.patternIds.push(patternId);
        return true;
    }

    public void popPatternId() {
        this.patternIds.pop();
    }

    @Deprecated
    public void setPreviousElementTextMove(float[] previousElementTextMove) {
    }

    @Deprecated
    public float[] getPreviousElementTextMove() {
        return new float[]{0.0f, 0.0f};
    }

    public SvgTextProperties getSvgTextProperties() {
        return this.textProperties;
    }

    public void setSvgTextProperties(SvgTextProperties textProperties) {
        this.textProperties = textProperties;
    }

    public float[] getRelativePosition() {
        return this.relativePosition;
    }

    public void moveRelativePosition(float dx, float dy) {
        this.relativePosition[0] = this.relativePosition[0] + dx;
        this.relativePosition[1] = this.relativePosition[1] + dy;
    }

    public void resetRelativePosition() {
        this.relativePosition = new float[]{0.0f, 0.0f};
    }

    public AffineTransform getClippingElementTransform() {
        return this.clippingElementTransform;
    }

    public void resetClippingElementTransform() {
        this.clippingElementTransform.setToIdentity();
    }

    public AffineTransform getConcatenatedTransform() {
        ArrayList<PdfCanvas> canvasList = new ArrayList<PdfCanvas>();
        int canvasesSize = this.size();
        for (int i = 0; i < canvasesSize; ++i) {
            canvasList.add(this.popCanvas());
        }
        AffineTransform transform = new AffineTransform();
        for (int i = canvasList.size() - 1; i >= 0; --i) {
            PdfCanvas pdfCanvas = (PdfCanvas)canvasList.get(i);
            Matrix matrix = pdfCanvas.getGraphicsState().getCtm();
            transform.concatenate(new AffineTransform(matrix.get(0), matrix.get(1), matrix.get(3), matrix.get(4), matrix.get(6), matrix.get(7)));
            this.pushCanvas(pdfCanvas);
        }
        return transform;
    }
}

