/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.resolver.font;

import com.itextpdf.io.util.ResourceUtil;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSet;
import com.itextpdf.layout.font.Range;
import com.itextpdf.layout.font.RangeBuilder;
import com.itextpdf.layout.renderer.TypographyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicFontProvider
extends FontProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicFontProvider.class);
    private static final String DEFAULT_FONT_FAMILY = "Times";
    private static final Range FREE_FONT_RANGE = new RangeBuilder().addRange(0, 1423).addRange(3712, Integer.MAX_VALUE).create();
    private static final String HTML_TO_PDF_SHIPPED_FONT_RESOURCE_PATH = "com/itextpdf/html2pdf/font/";
    private static final String[] HTML_TO_PDF_SHIPPED_FONT_NAMES = new String[]{"NotoSansMono-Regular.ttf", "NotoSansMono-Bold.ttf", "NotoSans-Regular.ttf", "NotoSans-Bold.ttf", "NotoSans-BoldItalic.ttf", "NotoSans-Italic.ttf", "NotoSerif-Regular.ttf", "NotoSerif-Bold.ttf", "NotoSerif-BoldItalic.ttf", "NotoSerif-Italic.ttf"};
    private final List<byte[]> calligraphyFontsTempList = new ArrayList<byte[]>();
    protected String shippedFontResourcePath;
    protected List<String> shippedFontNames;

    public BasicFontProvider() {
        this(true, false);
    }

    public BasicFontProvider(boolean registerStandardPdfFonts, boolean registerSystemFonts) {
        this(registerStandardPdfFonts, registerSystemFonts, DEFAULT_FONT_FAMILY);
    }

    public BasicFontProvider(boolean registerStandardPdfFonts, boolean registerShippedFonts, boolean registerSystemFonts) {
        this(registerStandardPdfFonts, registerShippedFonts, registerSystemFonts, DEFAULT_FONT_FAMILY);
    }

    public BasicFontProvider(boolean registerStandardPdfFonts, boolean registerSystemFonts, String defaultFontFamily) {
        this(registerStandardPdfFonts, true, registerSystemFonts, defaultFontFamily);
    }

    public BasicFontProvider(boolean registerStandardPdfFonts, boolean registerShippedFonts, boolean registerSystemFonts, String defaultFontFamily) {
        super(defaultFontFamily);
        if (registerStandardPdfFonts) {
            this.addStandardPdfFonts();
        }
        if (registerSystemFonts) {
            this.addSystemFonts();
        }
        if (registerShippedFonts) {
            this.initShippedFontsResourcePath();
            this.addAllAvailableFonts(this.addCalligraphFonts());
        }
    }

    public BasicFontProvider(FontSet fontSet, String defaultFontFamily) {
        super(fontSet, defaultFontFamily);
    }

    protected Range addCalligraphFonts() {
        if (TypographyUtils.isPdfCalligraphAvailable()) {
            try {
                Map<String, byte[]> fontStreams = TypographyUtils.loadShippedFonts();
                this.calligraphyFontsTempList.addAll(fontStreams.values());
                return FREE_FONT_RANGE;
            }
            catch (Exception e) {
                LOGGER.error("Error while loading font", e);
            }
        }
        return null;
    }

    protected void addShippedFonts(Range rangeToLoad) {
        if (!this.isResourcePathAvailable()) {
            return;
        }
        for (String fontName : this.shippedFontNames) {
            try {
                InputStream stream = ResourceUtil.getResourceStream(this.shippedFontResourcePath + fontName);
                Throwable throwable = null;
                try {
                    byte[] fontProgramBytes = StreamUtil.inputStreamToArray(stream);
                    this.addFont(fontProgramBytes, null, rangeToLoad);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while loading font", e);
            }
        }
    }

    protected void initShippedFontsResourcePath() {
        this.shippedFontResourcePath = HTML_TO_PDF_SHIPPED_FONT_RESOURCE_PATH;
        this.shippedFontNames = new ArrayList<String>();
        for (String font : HTML_TO_PDF_SHIPPED_FONT_NAMES) {
            this.shippedFontNames.add(font);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isResourcePathAvailable() {
        try (InputStream stream = ResourceUtil.getResourceStream(this.shippedFontResourcePath + this.shippedFontNames.get(0));){
            if (stream != null) return true;
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void addAllAvailableFonts(Range rangeToLoad) {
        this.addShippedFonts(rangeToLoad);
        for (byte[] fontData : this.calligraphyFontsTempList) {
            this.addFont(fontData, null);
        }
        this.calligraphyFontsTempList.clear();
    }
}

