/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.selector.item;

import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.styledxmlparser.css.selector.item.ICssSelectorItem;
import com.itextpdf.styledxmlparser.node.ICustomElementNode;
import com.itextpdf.styledxmlparser.node.IDocumentNode;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;

public class CssTagSelectorItem
implements ICssSelectorItem {
    private String tagName;
    private boolean isUniversal;

    public CssTagSelectorItem(String tagName) {
        this.tagName = StringNormalizer.toLowerCase(tagName);
        this.isUniversal = "*".equals(tagName);
    }

    @Override
    public int getSpecificity() {
        return this.isUniversal ? 0 : 1;
    }

    @Override
    public boolean matches(INode node) {
        if (!(node instanceof IElementNode) || node instanceof ICustomElementNode || node instanceof IDocumentNode) {
            return false;
        }
        IElementNode element = (IElementNode)node;
        return this.isUniversal || this.tagName.equals(element.name());
    }

    public String toString() {
        return this.tagName;
    }
}

